/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JacksonDataFormatConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        JacksonDataFormat dataformat = (JacksonDataFormat)target;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "objectmapper": 
            case "objectMapper": {
                dataformat.setObjectMapper(JacksonDataFormatConfigurer.property(camelContext, ObjectMapper.class, value));
                return true;
            }
            case "usedefaultobjectmapper": 
            case "useDefaultObjectMapper": {
                dataformat.setUseDefaultObjectMapper(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "collectiontype": 
            case "collectionType": {
                dataformat.setCollectionType(JacksonDataFormatConfigurer.property(camelContext, Class.class, value));
                return true;
            }
            case "moduleclassnames": 
            case "moduleClassNames": {
                dataformat.setModuleClassNames(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "modulerefs": 
            case "moduleRefs": {
                dataformat.setModuleRefs(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "unmarshaltype": 
            case "unmarshalType": {
                dataformat.setUnmarshalType(JacksonDataFormatConfigurer.property(camelContext, Class.class, value));
                return true;
            }
            case "jsonview": 
            case "jsonView": {
                dataformat.setJsonView(JacksonDataFormatConfigurer.property(camelContext, Class.class, value));
                return true;
            }
            case "include": {
                dataformat.setInclude(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "prettyprint": 
            case "prettyPrint": {
                dataformat.setPrettyPrint(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowjmstype": 
            case "allowJmsType": {
                dataformat.setAllowJmsType(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "uselist": 
            case "useList": {
                dataformat.setUseList(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "enablefeatures": 
            case "enableFeatures": {
                dataformat.setEnableFeatures(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "disablefeatures": 
            case "disableFeatures": {
                dataformat.setDisableFeatures(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "allowunmarshalltype": 
            case "allowUnmarshallType": {
                dataformat.setAllowUnmarshallType(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "contenttypeheader": 
            case "contentTypeHeader": {
                dataformat.setContentTypeHeader(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timezone": {
                dataformat.setTimezone(JacksonDataFormatConfigurer.property(camelContext, TimeZone.class, value));
                return true;
            }
            case "autodiscoverobjectmapper": 
            case "autoDiscoverObjectMapper": {
                dataformat.setAutoDiscoverObjectMapper(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "schemaresolver": 
            case "schemaResolver": {
                dataformat.setSchemaResolver(JacksonDataFormatConfigurer.property(camelContext, SchemaResolver.class, value));
                return true;
            }
            case "autodiscoverschemaresolver": 
            case "autoDiscoverSchemaResolver": {
                dataformat.setAutoDiscoverSchemaResolver(JacksonDataFormatConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "namingstrategy": 
            case "namingStrategy": {
                dataformat.setNamingStrategy(JacksonDataFormatConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }
}

