/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import org.apache.camel.component.mongodb.MongoDbTailTrackingConfig;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbTailTrackingManager {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbTailTrackingManager.class);
    public Object lastVal;
    private final MongoClient connection;
    private final MongoDbTailTrackingConfig config;
    private MongoCollection<Document> dbCol;
    private Document trackingObj;

    public MongoDbTailTrackingManager(MongoClient connection, MongoDbTailTrackingConfig config) {
        this.connection = connection;
        this.config = config;
    }

    public void initialize() {
        if (!this.config.persistent) {
            return;
        }
        this.dbCol = this.connection.getDatabase(this.config.db).getCollection(this.config.collection, Document.class);
        Document filter = new Document("persistentId", this.config.persistentId);
        this.trackingObj = (Document)this.dbCol.find(filter).first();
        if (this.trackingObj == null) {
            this.dbCol.insertOne(filter);
            this.trackingObj = (Document)this.dbCol.find(filter).first();
        }
        this.trackingObj = new Document("_id", this.trackingObj.get("_id"));
    }

    public synchronized void persistToStore() {
        if (!this.config.persistent || this.lastVal == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting lastVal={} to store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        Bson updateObj = Updates.set(this.config.field, this.lastVal);
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
        this.trackingObj = this.dbCol.findOneAndUpdate((Bson)this.trackingObj, updateObj, options);
    }

    public synchronized Object recoverFromStore() {
        if (!this.config.persistent) {
            return null;
        }
        this.lastVal = ((Document)this.dbCol.find(this.trackingObj).first()).get(this.config.field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovered lastVal={} from store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        return this.lastVal;
    }

    public void setLastVal(Document dbObj) {
        if (this.config.increasingField == null) {
            return;
        }
        this.lastVal = dbObj.get(this.config.increasingField);
    }

    public String getIncreasingFieldName() {
        return this.config.increasingField;
    }
}

