/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.verifier;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.mongodb.conf.ConnectionParamsConfiguration;
import org.apache.camel.util.CastUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Logger LOG = LoggerFactory.getLogger(MongoComponentVerifierExtension.class);
    private static final int CONNECTION_TIMEOUT = 2000;

    public MongoComponentVerifierExtension() {
        super("mongodb");
    }

    @Override
    public ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption("host", parameters)).error(ResultErrorHelper.requiresOption("user", parameters)).error(ResultErrorHelper.requiresOption("password", parameters));
        return builder.build();
    }

    @Override
    public ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        ConnectionParamsConfiguration mongoConf = new ConnectionParamsConfiguration(CastUtils.cast(parameters));
        MongoClientSettings.Builder optionsBuilder = MongoClientSettings.builder();
        optionsBuilder.applyToSocketSettings(socketBuilder -> socketBuilder.connectTimeout(2000, TimeUnit.MILLISECONDS));
        optionsBuilder.applyToConnectionPoolSettings(connectionPoolBuilder -> connectionPoolBuilder.maxWaitTime(2000L, TimeUnit.MILLISECONDS));
        optionsBuilder.applyToClusterSettings(clusterBuilder -> clusterBuilder.serverSelectionTimeout(2000L, TimeUnit.MILLISECONDS));
        ConnectionString connectionString = new ConnectionString(mongoConf.getMongoClientURI());
        optionsBuilder.applyConnectionString(connectionString);
        LOG.info("Testing connection against {}", (Object)connectionString);
        try (MongoClient mongoClient = MongoClients.create(connectionString);){
            MongoDatabase database = mongoClient.getDatabase(mongoConf.getAdminDB());
            database.runCommand(Document.parse("{ ping: 1 }"));
            LOG.info("Testing connection successful!");
        }
        catch (MongoSecurityException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, String.format("Unable to authenticate %s against %s authentication database!", mongoConf.getUser(), mongoConf.getAdminDB()));
            builder.error(errorBuilder.build());
        }
        catch (MongoTimeoutException e) {
            String description;
            ComponentVerifierExtension.VerificationError.StandardCode code = ComponentVerifierExtension.VerificationError.StandardCode.GENERIC;
            if (e.getMessage().contains("com.mongodb.MongoSecurityException")) {
                code = ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION;
                description = String.format("Unable to authenticate %s against %s authentication database!", mongoConf.getUser(), mongoConf.getAdminDB());
            } else {
                description = e.getMessage().contains("com.mongodb.MongoSocket") && e.getMessage().contains("Exception") ? String.format("Unable to connect to %s!", mongoConf.getHost()) : String.format("Generic exception while connecting to %s!", mongoConf.getHost());
            }
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription(code, String.format(description, new Object[0]));
            builder.error(errorBuilder.build());
        }
    }
}

