/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.LocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.util.OrderedProperties;

public class RefPropertiesSource
implements LocationPropertiesSource {
    private final PropertiesComponent propertiesComponent;
    private final PropertiesLocation location;

    public RefPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        this.propertiesComponent = propertiesComponent;
        this.location = location;
    }

    @Override
    public String getName() {
        return "RefPropertiesSource[" + this.getLocation().getPath() + "]";
    }

    @Override
    public PropertiesLocation getLocation() {
        return this.location;
    }

    @Override
    public String getProperty(String name) {
        Properties properties = this.lookupPropertiesInRegistry(this.propertiesComponent, this.location);
        if (properties != null) {
            return properties.getProperty(name);
        }
        return null;
    }

    protected Properties lookupPropertiesInRegistry(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        String path = location.getPath();
        Properties answer = null;
        Object obj = propertiesComponent.getCamelContext().getRegistry().lookupByName(path);
        if (obj instanceof Properties) {
            answer = (Properties)obj;
        } else if (obj instanceof Map) {
            answer = new OrderedProperties();
            answer.putAll((Map<?, ?>)((Map)obj));
        } else if (!propertiesComponent.isIgnoreMissingLocation() && !location.isOptional()) {
            throw RuntimeCamelException.wrapRuntimeCamelException(new FileNotFoundException("Properties " + path + " not found in registry"));
        }
        return answer;
    }
}

