/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;

public class DefaultDependencyInjectionAnnotationFactory
implements CamelDependencyInjectionAnnotationFactory,
CamelContextAware {
    private ExtendedCamelContext camelContext;

    public DefaultDependencyInjectionAnnotationFactory(CamelContext camelContext) {
        this.camelContext = camelContext.adapt(ExtendedCamelContext.class);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext.adapt(ExtendedCamelContext.class);
    }

    @Override
    public Runnable createBindToRegistryFactory(String id, Object bean, String beanName, boolean beanPostProcess) {
        return () -> {
            if (beanPostProcess) {
                try {
                    this.camelContext.getBeanPostProcessor().postProcessBeforeInitialization(bean, beanName);
                    this.camelContext.adapt(ExtendedCamelContext.class).getBeanPostProcessor().postProcessAfterInitialization(bean, beanName);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            }
            CamelContextAware.trySetCamelContext(bean, this.camelContext);
            this.camelContext.getRegistry().bind(id, bean);
        };
    }
}

