/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.spi.RouteStartupOrder;

public class DefaultRouteStartupOrder
implements RouteStartupOrder {
    private final int startupOrder;
    private final Route route;
    private final RouteService routeService;

    public DefaultRouteStartupOrder(int startupOrder, Route route, RouteService routeService) {
        this.startupOrder = startupOrder;
        this.route = route;
        this.routeService = routeService;
    }

    @Override
    public int getStartupOrder() {
        return this.startupOrder;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public Consumer getInput() {
        return this.routeService.getInput();
    }

    @Override
    public List<Service> getServices() {
        List<Service> services = this.routeService.getRoute().getServices();
        return new ArrayList<Service>(services);
    }

    public RouteService getRouteService() {
        return this.routeService;
    }

    public String toString() {
        return "Route " + this.route.getId() + " starts in order " + this.startupOrder;
    }
}

