/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="loadBalance")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalanceDefinition
extends OutputDefinition<LoadBalanceDefinition> {
    @XmlElements(value={@XmlElement(name="customLoadBalancer", type=CustomLoadBalancerDefinition.class), @XmlElement(name="failover", type=FailoverLoadBalancerDefinition.class), @XmlElement(name="random", type=RandomLoadBalancerDefinition.class), @XmlElement(name="roundRobin", type=RoundRobinLoadBalancerDefinition.class), @XmlElement(name="sticky", type=StickyLoadBalancerDefinition.class), @XmlElement(name="topic", type=TopicLoadBalancerDefinition.class), @XmlElement(name="weighted", type=WeightedLoadBalancerDefinition.class)})
    private LoadBalancerDefinition loadBalancerType;

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public LoadBalancerDefinition getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerDefinition loadbalancer) {
        if (this.loadBalancerType != null) {
            throw new IllegalArgumentException("Loadbalancer already configured to: " + this.loadBalancerType + ". Cannot set it to: " + loadbalancer);
        }
        this.loadBalancerType = loadbalancer;
    }

    @Override
    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        CustomLoadBalancerDefinition def = new CustomLoadBalancerDefinition();
        def.setCustomLoadBalancer(loadBalancer);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition failover() {
        return this.failover(-1, true, false, new Class[0]);
    }

    public LoadBalanceDefinition failover(Class<?> ... exceptions) {
        return this.failover(-1, true, false, exceptions);
    }

    public LoadBalanceDefinition failover(int maximumFailoverAttempts, boolean inheritErrorHandler, boolean roundRobin, Class<?> ... exceptions) {
        return this.failover(maximumFailoverAttempts, inheritErrorHandler, roundRobin, false, exceptions);
    }

    public LoadBalanceDefinition failover(int maximumFailoverAttempts, boolean inheritErrorHandler, boolean roundRobin, boolean sticky, Class<?> ... exceptions) {
        FailoverLoadBalancerDefinition def = new FailoverLoadBalancerDefinition();
        def.setExceptionTypes(Arrays.asList(exceptions));
        def.setMaximumFailoverAttempts(Integer.toString(maximumFailoverAttempts));
        def.setRoundRobin(Boolean.toString(roundRobin));
        def.setSticky(Boolean.toString(sticky));
        this.setLoadBalancerType(def);
        this.setInheritErrorHandler(inheritErrorHandler);
        return this;
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio) {
        return this.weighted(roundRobin, distributionRatio, ",");
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio, String distributionRatioDelimiter) {
        WeightedLoadBalancerDefinition def = new WeightedLoadBalancerDefinition();
        def.setRoundRobin(Boolean.toString(roundRobin));
        def.setDistributionRatio(distributionRatio);
        def.setDistributionRatioDelimiter(distributionRatioDelimiter);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition roundRobin() {
        this.setLoadBalancerType(new RoundRobinLoadBalancerDefinition());
        return this;
    }

    public LoadBalanceDefinition random() {
        this.setLoadBalancerType(new RandomLoadBalancerDefinition());
        return this;
    }

    public LoadBalanceDefinition custom(String ref) {
        CustomLoadBalancerDefinition balancer = new CustomLoadBalancerDefinition();
        balancer.setRef(ref);
        this.setLoadBalancerType(balancer);
        return this;
    }

    public LoadBalanceDefinition sticky(Expression correlationExpression) {
        StickyLoadBalancerDefinition def = new StickyLoadBalancerDefinition();
        def.setCorrelationExpression(correlationExpression);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition topic() {
        this.setLoadBalancerType(new TopicLoadBalancerDefinition());
        return this;
    }

    @Override
    public String getShortName() {
        return "loadBalance";
    }

    @Override
    public String getLabel() {
        return this.getOutputs().stream().map(ProcessorDefinition::getLabel).collect(Collectors.joining(",", this.getShortName() + "[", "]"));
    }

    @Override
    public String toString() {
        return "LoadBalanceType[" + this.loadBalancerType + ", " + this.getOutputs() + "]";
    }
}

