/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

@Metadata(label="configuration")
@XmlRootElement(name="threadPoolProfile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadPoolProfileDefinition
extends OptionalIdentifiedDefinition<ThreadPoolProfileDefinition> {
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String defaultProfile;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String poolSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String maxPoolSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Long")
    private String keepAliveTime;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.TimeUnit", enums="NANOSECONDS,MICROSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String timeUnit;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String maxQueueSize;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowCoreThreadTimeOut;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy", enums="Abort,CallerRuns,DiscardOldest,Discard")
    private String rejectedPolicy;

    @Override
    public String getShortName() {
        return "threadPoolProfile";
    }

    @Override
    public String getLabel() {
        return "ThreadPoolProfile " + this.getId();
    }

    public ThreadPoolProfileDefinition poolSize(int poolSize) {
        return this.poolSize(Integer.toString(poolSize));
    }

    public ThreadPoolProfileDefinition poolSize(String poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadPoolProfileDefinition maxPoolSize(int maxPoolSize) {
        return this.maxPoolSize(Integer.toString(maxPoolSize));
    }

    public ThreadPoolProfileDefinition maxPoolSize(String maxPoolSize) {
        this.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadPoolProfileDefinition keepAliveTime(long keepAliveTime) {
        return this.keepAliveTime(Long.toString(keepAliveTime));
    }

    public ThreadPoolProfileDefinition keepAliveTime(String keepAliveTime) {
        this.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolProfileDefinition timeUnit(TimeUnit timeUnit) {
        return this.timeUnit(timeUnit.name());
    }

    public ThreadPoolProfileDefinition timeUnit(String timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public ThreadPoolProfileDefinition maxQueueSize(int maxQueueSize) {
        return this.maxQueueSize(Integer.toString(maxQueueSize));
    }

    public ThreadPoolProfileDefinition maxQueueSize(String maxQueueSize) {
        this.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadPoolProfileDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy.name());
        return this;
    }

    public ThreadPoolProfileDefinition rejectedPolicy(String rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ThreadPoolProfileDefinition allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        return this.allowCoreThreadTimeOut(Boolean.toString(allowCoreThreadTimeOut));
    }

    public ThreadPoolProfileDefinition allowCoreThreadTimeOut(String allowCoreThreadTimeOut) {
        this.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        return this;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(String allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(String rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }
}

