/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceExpressionFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.cloud.ServiceCallConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceChooserConfiguration;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;

@Metadata(label="routing,cloud")
@XmlRootElement(name="serviceExpression")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
@Deprecated
public class ServiceCallExpressionConfiguration
extends ServiceCallConfiguration
implements ServiceExpressionFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;
    @XmlAttribute
    @Metadata(defaultValue="CamelServiceCallServiceHost")
    private String hostHeader = "CamelServiceCallServiceHost";
    @XmlAttribute
    @Metadata(defaultValue="CamelServiceCallServicePort")
    private String portHeader = "CamelServiceCallServicePort";
    @XmlElementRef(required=false)
    private ExpressionDefinition expressionType;
    @XmlTransient
    private Expression expression;

    public ServiceCallExpressionConfiguration() {
        this(null, null);
    }

    public ServiceCallExpressionConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    @Override
    public ServiceCallServiceChooserConfiguration property(String key, String value) {
        return (ServiceCallServiceChooserConfiguration)super.property(key, value);
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this.hostHeader = hostHeader;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public void setPortHeader(String portHeader) {
        this.portHeader = portHeader;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ServiceCallExpressionConfiguration hostHeader(String hostHeader) {
        this.setHostHeader(hostHeader);
        return this;
    }

    public ServiceCallExpressionConfiguration portHeader(String portHeader) {
        this.setPortHeader(portHeader);
        return this;
    }

    public ServiceCallExpressionConfiguration expressionType(ExpressionDefinition expressionType) {
        this.setExpressionType(expressionType);
        return this;
    }

    public ServiceCallExpressionConfiguration expression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    @Override
    public Expression newInstance(CamelContext camelContext) throws Exception {
        Expression answer = this.getExpression();
        if (answer != null) {
            return answer;
        }
        ExpressionDefinition expressionType = this.getExpressionType();
        if (expressionType != null) {
            return expressionType.createExpression(camelContext);
        }
        if (this.factoryKey != null) {
            ServiceExpressionFactory factory = CamelContextHelper.lookup(camelContext, this.factoryKey, ServiceExpressionFactory.class);
            if (factory != null) {
                answer = (Expression)factory.newInstance(camelContext);
            } else {
                Class type;
                try {
                    type = camelContext.adapt(ExtendedCamelContext.class).getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey).orElse(null);
                }
                catch (Exception e) {
                    throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, e);
                }
                if (type != null) {
                    if (ServiceExpressionFactory.class.isAssignableFrom(type)) {
                        factory = (ServiceExpressionFactory)camelContext.getInjector().newInstance(type, false);
                    } else {
                        throw new IllegalArgumentException("Resolving Expression: " + this.factoryKey + " detected type conflict: Not a ExpressionFactory implementation. Found: " + type.getName());
                    }
                }
                try {
                    Map<String, Object> parameters = this.getConfiguredOptions(camelContext, this);
                    parameters.replaceAll((k, v) -> {
                        if (v instanceof String) {
                            try {
                                v = camelContext.resolvePropertyPlaceholders((String)v);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v.toString()), e);
                            }
                        }
                        return v;
                    });
                    Map<String, String> map = this.getPropertiesAsMap(camelContext);
                    if (map != null && !map.isEmpty()) {
                        parameters.put("properties", map);
                    }
                    this.postProcessFactoryParameters(camelContext, parameters);
                    PropertyBindingSupport.build().bind(camelContext, factory, parameters);
                    answer = (Expression)factory.newInstance(camelContext);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return answer;
    }
}

