/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.17.0", label="dataformat,transformation", title="MIME Multipart")
@XmlRootElement(name="mimeMultipart")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MimeMultipartDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="mixed")
    private String multipartSubType = "mixed";
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String multipartWithoutAttachment;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String headersInline;
    @XmlAttribute
    private String includeHeaders;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String binaryContent;

    public MimeMultipartDataFormat() {
        super("mimeMultipart");
    }

    private MimeMultipartDataFormat(Builder builder) {
        this();
        this.multipartSubType = builder.multipartSubType;
        this.multipartWithoutAttachment = builder.multipartWithoutAttachment;
        this.headersInline = builder.headersInline;
        this.includeHeaders = builder.includeHeaders;
        this.binaryContent = builder.binaryContent;
    }

    public String getMultipartSubType() {
        return this.multipartSubType;
    }

    public void setMultipartSubType(String multipartSubType) {
        this.multipartSubType = multipartSubType;
    }

    public String getMultipartWithoutAttachment() {
        return this.multipartWithoutAttachment;
    }

    public void setMultipartWithoutAttachment(String multipartWithoutAttachment) {
        this.multipartWithoutAttachment = multipartWithoutAttachment;
    }

    public String getHeadersInline() {
        return this.headersInline;
    }

    public void setHeadersInline(String headersInline) {
        this.headersInline = headersInline;
    }

    public String getBinaryContent() {
        return this.binaryContent;
    }

    public void setIncludeHeaders(String includeHeaders) {
        this.includeHeaders = includeHeaders;
    }

    public String getIncludeHeaders() {
        return this.includeHeaders;
    }

    public void setBinaryContent(String binaryContent) {
        this.binaryContent = binaryContent;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<MimeMultipartDataFormat> {
        private String multipartSubType = "mixed";
        private String multipartWithoutAttachment;
        private String headersInline;
        private String includeHeaders;
        private String binaryContent;

        public Builder multipartSubType(String multipartSubType) {
            this.multipartSubType = multipartSubType;
            return this;
        }

        public Builder multipartWithoutAttachment(String multipartWithoutAttachment) {
            this.multipartWithoutAttachment = multipartWithoutAttachment;
            return this;
        }

        public Builder multipartWithoutAttachment(boolean multipartWithoutAttachment) {
            this.multipartWithoutAttachment = Boolean.toString(multipartWithoutAttachment);
            return this;
        }

        public Builder headersInline(String headersInline) {
            this.headersInline = headersInline;
            return this;
        }

        public Builder headersInline(boolean headersInline) {
            this.headersInline = Boolean.toString(headersInline);
            return this;
        }

        public Builder includeHeaders(String includeHeaders) {
            this.includeHeaders = includeHeaders;
            return this;
        }

        public Builder binaryContent(String binaryContent) {
            this.binaryContent = binaryContent;
            return this;
        }

        public Builder binaryContent(boolean binaryContent) {
            this.binaryContent = Boolean.toString(binaryContent);
            return this;
        }

        @Override
        public MimeMultipartDataFormat end() {
            return new MimeMultipartDataFormat(this);
        }
    }
}

