/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.20.0", label="dataformat,transformation", title="Thrift")
@XmlRootElement(name="thrift")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThriftDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlTransient
    private Object defaultInstance;
    @XmlAttribute
    private String instanceClass;
    @XmlAttribute
    @Metadata(enums="binary,json,sjson", defaultValue="binary")
    private String contentTypeFormat;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;

    public ThriftDataFormat() {
        super("thrift");
    }

    public ThriftDataFormat(String instanceClass) {
        this();
        this.setInstanceClass(instanceClass);
    }

    public ThriftDataFormat(String instanceClass, String contentTypeFormat) {
        this();
        this.setInstanceClass(instanceClass);
        this.setContentTypeFormat(contentTypeFormat);
    }

    private ThriftDataFormat(Builder builder) {
        this();
        this.defaultInstance = builder.defaultInstance;
        this.instanceClass = builder.instanceClass;
        this.contentTypeFormat = builder.contentTypeFormat;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public void setContentTypeFormat(String contentTypeFormat) {
        this.contentTypeFormat = contentTypeFormat;
    }

    public String getContentTypeFormat() {
        return this.contentTypeFormat;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public void setDefaultInstance(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ThriftDataFormat> {
        private Object defaultInstance;
        private String instanceClass;
        private String contentTypeFormat;
        private String contentTypeHeader;

        public Builder instanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
            return this;
        }

        public Builder contentTypeFormat(String contentTypeFormat) {
            this.contentTypeFormat = contentTypeFormat;
            return this;
        }

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        public Builder defaultInstance(Object defaultInstance) {
            this.defaultInstance = defaultInstance;
            return this;
        }

        @Override
        public ThriftDataFormat end() {
            return new ThriftDataFormat(this);
        }
    }
}

