/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.errorhandler;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration,error")
@XmlRootElement(name="deadLetterChannel")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DeadLetterChannelDefinition
extends DefaultErrorHandlerDefinition {
    @XmlAttribute(required=true)
    private String deadLetterUri;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String deadLetterHandleNewException;

    public DeadLetterChannelDefinition() {
    }

    public DeadLetterChannelDefinition(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public DeadLetterChannelDefinition(Endpoint deadLetterUri) {
        this.deadLetterUri = deadLetterUri.getEndpointUri();
    }

    @Override
    protected RedeliveryPolicyDefinition createRedeliveryPolicy() {
        RedeliveryPolicyDefinition answer = super.createRedeliveryPolicy();
        answer.setLogExhausted("false");
        return answer;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public String getDeadLetterHandleNewException() {
        return this.deadLetterHandleNewException;
    }

    public void setDeadLetterHandleNewException(String deadLetterHandleNewException) {
        this.deadLetterHandleNewException = deadLetterHandleNewException;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerFactory cloneBuilder() {
        DeadLetterChannelDefinition answer = new DeadLetterChannelDefinition();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(DeadLetterChannelDefinition other) {
        other.setDeadLetterUri(this.getDeadLetterUri());
        other.setDeadLetterHandleNewException(this.getDeadLetterHandleNewException());
        super.cloneBuilder(other);
    }

    public DeadLetterChannelDefinition deadLetterUri(String deadLetterUri) {
        this.setDeadLetterUri(deadLetterUri);
        return this;
    }

    public DefaultErrorHandlerDefinition deadLetterHandleNewException(boolean handleNewException) {
        this.setDeadLetterHandleNewException(handleNewException ? "true" : "false");
        return this;
    }
}

