/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.ApiKeyDefinition;
import org.apache.camel.model.rest.BasicAuthDefinition;
import org.apache.camel.model.rest.BearerTokenDefinition;
import org.apache.camel.model.rest.MutualTLSDefinition;
import org.apache.camel.model.rest.OAuth2Definition;
import org.apache.camel.model.rest.OpenIdConnectDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestSecurityDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="rest,security,configuration", title="Rest Security Definitions")
@XmlRootElement(name="securityDefinitions")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestSecuritiesDefinition {
    @XmlTransient
    private RestDefinition rest;
    @XmlElements(value={@XmlElement(name="apiKey", type=ApiKeyDefinition.class), @XmlElement(name="basicAuth", type=BasicAuthDefinition.class), @XmlElement(name="bearer", type=BearerTokenDefinition.class), @XmlElement(name="oauth2", type=OAuth2Definition.class), @XmlElement(name="openIdConnect", type=OpenIdConnectDefinition.class), @XmlElement(name="mutualTLS", type=MutualTLSDefinition.class)})
    private List<RestSecurityDefinition> securityDefinitions = new ArrayList<RestSecurityDefinition>();

    public RestSecuritiesDefinition() {
    }

    public RestSecuritiesDefinition(RestDefinition rest) {
        this.rest = rest;
    }

    public List<RestSecurityDefinition> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(List<RestSecurityDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public ApiKeyDefinition apiKey(String key) {
        return this.apiKey(key, null);
    }

    public ApiKeyDefinition apiKey(String key, String description) {
        ApiKeyDefinition auth = new ApiKeyDefinition(this.rest);
        auth.setKey(key);
        auth.setDescription(description);
        this.securityDefinitions.add(auth);
        return auth;
    }

    public RestSecuritiesDefinition basicAuth(String key) {
        return this.basicAuth(key, null);
    }

    public RestSecuritiesDefinition basicAuth(String key, String description) {
        BasicAuthDefinition auth = new BasicAuthDefinition(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        return this;
    }

    public RestSecuritiesDefinition bearerToken(String key, String bearerFormat) {
        return this.bearerToken(key, null, bearerFormat);
    }

    public RestSecuritiesDefinition bearerToken(String key, String description, String bearerFormat) {
        BearerTokenDefinition auth = new BearerTokenDefinition(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        auth.setFormat(bearerFormat);
        return this;
    }

    public RestSecuritiesDefinition mutualTLS(String key) {
        return this.mutualTLS(key, null);
    }

    public RestSecuritiesDefinition mutualTLS(String key, String description) {
        MutualTLSDefinition auth = new MutualTLSDefinition(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        return this;
    }

    public RestSecuritiesDefinition openIdConnect(String key, String url) {
        return this.openIdConnect(key, null, url);
    }

    public RestSecuritiesDefinition openIdConnect(String key, String description, String url) {
        OpenIdConnectDefinition auth = new OpenIdConnectDefinition(this.rest);
        this.securityDefinitions.add(auth);
        auth.setKey(key);
        auth.setDescription(description);
        auth.setUrl(url);
        return this;
    }

    public OAuth2Definition oauth2(String key) {
        return this.oauth2(key, null);
    }

    public OAuth2Definition oauth2(String key, String description) {
        OAuth2Definition auth = new OAuth2Definition(this.rest);
        auth.setKey(key);
        auth.setDescription(description);
        this.securityDefinitions.add(auth);
        return auth;
    }

    public RestDefinition end() {
        return this.rest;
    }
}

