/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.support.service.ServiceSupport;

public class MemoryAggregationRepository
extends ServiceSupport
implements OptimisticLockingAggregationRepository {
    private final ConcurrentMap<String, Exchange> cache = new ConcurrentHashMap<String, Exchange>();
    private final boolean optimisticLocking;

    public MemoryAggregationRepository() {
        this(false);
    }

    public MemoryAggregationRepository(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
        if (!this.optimisticLocking) {
            throw new UnsupportedOperationException();
        }
        if (oldExchange == null ? this.cache.putIfAbsent(key, newExchange) != null : !this.cache.replace(key, oldExchange, newExchange)) {
            throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
        }
        return oldExchange;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        if (this.optimisticLocking) {
            throw new UnsupportedOperationException();
        }
        return this.cache.put(key, exchange);
    }

    @Override
    public Exchange get(CamelContext camelContext, String key) {
        return (Exchange)this.cache.get(key);
    }

    @Override
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        if (this.optimisticLocking) {
            if (!this.cache.remove(key, exchange)) {
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
        } else {
            this.cache.remove(key);
        }
    }

    @Override
    public void confirm(CamelContext camelContext, String exchangeId) {
    }

    @Override
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

