/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTransformer
extends Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorTransformer.class);
    private Processor processor;
    private String transformerString;

    public ProcessorTransformer(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void transform(Message message, DataType from, DataType to) throws Exception {
        Exchange exchange = message.getExchange();
        CamelContext context = exchange.getContext();
        if (from.isJavaType()) {
            Object input = message.getBody();
            Class<?> fromClass = context.getClassResolver().resolveClass(from.getName());
            if (!fromClass.isAssignableFrom(input.getClass())) {
                LOG.debug("Converting to: {}", (Object)fromClass.getName());
                input = context.getTypeConverter().mandatoryConvertTo(fromClass, input);
                message.setBody(input);
            }
        }
        LOG.debug("Sending to transform processor: {}", (Object)this.processor);
        DefaultExchange transformExchange = new DefaultExchange(exchange);
        transformExchange.setIn(message);
        transformExchange.adapt(ExtendedExchange.class).setProperties(exchange.getProperties());
        this.processor.process(transformExchange);
        Message answer = transformExchange.getMessage();
        if (to.isJavaType()) {
            Object answerBody = answer.getBody();
            Class<?> toClass = context.getClassResolver().resolveClass(to.getName());
            if (!toClass.isAssignableFrom(answerBody.getClass())) {
                LOG.debug("Converting to: {}", (Object)toClass.getName());
                answerBody = context.getTypeConverter().mandatoryConvertTo(toClass, answerBody);
                answer.setBody(answerBody);
            }
        }
        message.copyFrom(answer);
    }

    public ProcessorTransformer setProcessor(Processor processor) {
        this.processor = processor;
        this.transformerString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.transformerString == null) {
            this.transformerString = String.format("ProcessorTransformer[scheme='%s', from='%s', to='%s', processor='%s']", this.getModel(), this.getFrom(), this.getTo(), this.processor);
        }
        return this.transformerString;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.processor, "processor", this);
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }
}

