/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validator;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorValidator
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorValidator.class);
    private Processor processor;
    private String validatorString;

    public ProcessorValidator(CamelContext context) {
        this.setCamelContext(context);
    }

    @Override
    public void validate(Message message, DataType type) throws ValidationException {
        Exchange exchange = message.getExchange();
        LOG.debug("Sending to validate processor '{}'", (Object)this.processor);
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false, true);
        try {
            this.processor.process(copy);
            if (copy.getException() != null) {
                exchange.setException(copy.getException());
            } else {
                ExchangeHelper.copyResults(exchange, copy);
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            throw new ValidationException(String.format("Validation failed for '%s'", type), exchange, e);
        }
    }

    public ProcessorValidator setProcessor(Processor processor) {
        this.processor = processor;
        this.validatorString = null;
        return this;
    }

    @Override
    public String toString() {
        if (this.validatorString == null) {
            this.validatorString = String.format("ProcessorValidator[type='%s', processor='%s']", this.getType(), this.processor);
        }
        return this.validatorString;
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.processor, "processor", this);
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }
}

