/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Comparator;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.processor.SortProcessor;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.support.ObjectHelper;

public class SortReifier<T, U extends SortDefinition<T>>
extends ExpressionReifier<U> {
    public SortReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SortDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Comparator comp = ((SortDefinition)this.definition).getComparatorBean();
        if (comp == null && ((SortDefinition)this.definition).getComparator() != null) {
            comp = this.mandatoryLookup(((SortDefinition)this.definition).getComparator(), Comparator.class);
        }
        if (comp == null) {
            comp = (o1, o2) -> ObjectHelper.compare(o1, o2);
        }
        Expression exp = ((SortDefinition)this.definition).getExpression() == null ? this.camelContext.resolveLanguage("simple").createExpression("${body}") : this.createExpression(((SortDefinition)this.definition).getExpression());
        return new SortProcessor(exp, comp);
    }
}

