/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.StringHelper;

public class ToDynamicReifier<T extends ToDynamicDefinition>
extends ProcessorReifier<T> {
    public ToDynamicReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ToDynamicDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Expression exp;
        String uri;
        if (((ToDynamicDefinition)this.definition).getEndpointProducerBuilder() != null) {
            uri = ((ToDynamicDefinition)this.definition).getEndpointProducerBuilder().getRawUri();
            exp = ((ToDynamicDefinition)this.definition).getEndpointProducerBuilder().expr(this.camelContext);
        } else {
            uri = StringHelper.notEmpty(((ToDynamicDefinition)this.definition).getUri(), "uri", this);
            exp = this.createExpression(uri);
        }
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute(this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        }
        SendDynamicProcessor processor = new SendDynamicProcessor(uri, exp);
        processor.setCamelContext(this.camelContext);
        processor.setPattern(this.parse(ExchangePattern.class, ((ToDynamicDefinition)this.definition).getPattern()));
        Integer num = this.parseInt(((ToDynamicDefinition)this.definition).getCacheSize());
        if (num != null) {
            processor.setCacheSize(num);
        }
        if (((ToDynamicDefinition)this.definition).getIgnoreInvalidEndpoint() != null) {
            processor.setIgnoreInvalidEndpoint(this.parseBoolean(((ToDynamicDefinition)this.definition).getIgnoreInvalidEndpoint(), false));
        }
        if (((ToDynamicDefinition)this.definition).getAllowOptimisedComponents() != null) {
            processor.setAllowOptimisedComponents(this.parseBoolean(((ToDynamicDefinition)this.definition).getAllowOptimisedComponents(), true));
        }
        if (((ToDynamicDefinition)this.definition).getAutoStartComponents() != null) {
            processor.setAutoStartupComponents(this.parseBoolean(((ToDynamicDefinition)this.definition).getAutoStartComponents(), true));
        }
        return processor;
    }

    protected Expression createExpression(String uri) {
        uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        String language = "simple";
        if (uri.startsWith("language:")) {
            String value = StringHelper.after(uri, "language:");
            language = StringHelper.before(value, ":");
            uri = StringHelper.after(value, ":");
        }
        Language lan = this.camelContext.resolveLanguage(language);
        return lan.createExpression(uri);
    }
}

