/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gridfs;

import com.mongodb.Mongo;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.gridfs.GridFsEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridFsComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(GridFsComponent.class);
    private volatile Mongo db;

    public GridFsComponent() {
        super(GridFsEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.db == null) {
            this.db = (Mongo)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)remaining, Mongo.class);
            LOG.debug("Resolved the connection with the name {} as {}", (Object)remaining, (Object)this.db);
        }
        GridFsEndpoint endpoint = new GridFsEndpoint(uri, this);
        parameters.put("mongoConnection", this.db);
        endpoint.setConnectionBean(remaining);
        endpoint.setMongoConnection(this.db);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doShutdown() throws Exception {
        if (this.db != null) {
            LOG.debug("Closing the connection {} on {}", (Object)this.db, (Object)this);
            this.db.close();
        }
        super.doShutdown();
    }
}

