/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.FragmentKey;
import com.github.mustachejava.Iteration;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.TemplateFunction;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.util.LatchedWriter;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class IterableCode
extends DefaultCode
implements Iteration {
    private final ExecutorService les;

    public IterableCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable, String type) {
        super(tc, df, mustache, variable, type);
        this.les = df.getExecutorService();
    }

    public IterableCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
        this(tc, df, mustache, variable, "#");
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        Object resolved = this.get(scopes);
        writer = this.handle(writer, resolved, scopes);
        this.appendText(writer);
        return writer;
    }

    protected Writer handle(Writer writer, Object resolved, Object[] scopes) {
        if (resolved != null) {
            writer = resolved instanceof Function ? this.handleFunction(writer, (Function)resolved, scopes) : (resolved instanceof Callable ? this.handleCallable(writer, (Callable)resolved, scopes) : this.execute(writer, resolved, scopes));
        }
        return writer;
    }

    protected Writer handleCallable(Writer writer, final Callable callable, Object[] scopes) {
        if (this.les == null) {
            try {
                writer = this.execute(writer, callable.call(), scopes);
            }
            catch (Exception e) {
                throw new MustacheException(e);
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to flush writer", e);
        }
        final Writer originalWriter = writer;
        final LatchedWriter latchedWriter = new LatchedWriter(writer);
        writer = latchedWriter;
        final Object[] newScopes = (Object[])scopes.clone();
        this.les.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object call = callable.call();
                    Writer subWriter = IterableCode.this.handle(originalWriter, call, newScopes);
                    if (subWriter instanceof LatchedWriter) {
                        ((LatchedWriter)subWriter).await();
                    }
                    latchedWriter.done();
                }
                catch (Throwable e) {
                    latchedWriter.failed(e);
                }
            }
        });
        return writer;
    }

    protected Writer handleFunction(Writer writer, Function function, Object[] scopes) {
        StringWriter sw = new StringWriter();
        this.runIdentity(sw);
        if (function instanceof TemplateFunction) {
            Object newtemplate = function.apply(sw.toString());
            if (newtemplate != null) {
                String templateText = newtemplate.toString();
                writer = this.writeTemplate(writer, templateText, scopes);
            }
        } else {
            try {
                StringWriter capture = new StringWriter();
                this.writeTemplate(capture, sw.toString(), scopes).close();
                Object apply = function.apply(capture.toString());
                if (apply != null) {
                    writer.write(apply.toString());
                }
            }
            catch (IOException e) {
                throw new MustacheException("Failed to write function result", e);
            }
        }
        return writer;
    }

    protected Writer writeTemplate(Writer writer, String templateText, Object[] scopes) {
        return this.df.getFragment(new FragmentKey(this.tc, templateText)).execute(writer, scopes);
    }

    protected Writer execute(Writer writer, Object resolve, Object[] scopes) {
        return this.oh.iterate(this, writer, resolve, scopes);
    }

    @Override
    public Writer next(Writer writer, Object next, Object ... scopes) {
        Object[] iteratorScopes = this.addScope(scopes, next);
        writer = this.run(writer, iteratorScopes);
        return writer;
    }
}

