/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mustache;

import org.apache.camel.CamelContext;
import org.apache.camel.component.mustache.MustacheEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class MustacheEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MustacheEndpoint target = (MustacheEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                target.setAllowContextMapAll(MustacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                target.setAllowTemplateFromHeader(MustacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "contentcache": 
            case "contentCache": {
                target.setContentCache(MustacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "encoding": {
                target.setEncoding(MustacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "enddelimiter": 
            case "endDelimiter": {
                target.setEndDelimiter(MustacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(MustacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "startdelimiter": 
            case "startDelimiter": {
                target.setStartDelimiter(MustacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return Boolean.TYPE;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return Boolean.TYPE;
            }
            case "contentcache": 
            case "contentCache": {
                return Boolean.TYPE;
            }
            case "encoding": {
                return String.class;
            }
            case "enddelimiter": 
            case "endDelimiter": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "startdelimiter": 
            case "startDelimiter": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MustacheEndpoint target = (MustacheEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return target.isAllowContextMapAll();
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return target.isAllowTemplateFromHeader();
            }
            case "contentcache": 
            case "contentCache": {
                return target.isContentCache();
            }
            case "encoding": {
                return target.getEncoding();
            }
            case "enddelimiter": 
            case "endDelimiter": {
                return target.getEndDelimiter();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "startdelimiter": 
            case "startDelimiter": {
                return target.getStartDelimiter();
            }
        }
        return null;
    }
}

