/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

class AbstractExchange
implements ExtendedExchange {
    static final int INTERNAL_LENGTH = ExchangePropertyKey.values().length;
    static final Object[] EMPTY_INTERNAL_PROPERTIES = new Object[INTERNAL_LENGTH];
    final CamelContext context;
    Map<String, Object> properties;
    final Object[] internalProperties = new Object[INTERNAL_LENGTH];
    long created;
    Message in;
    Message out;
    Exception exception;
    String exchangeId;
    UnitOfWork unitOfWork;
    ExchangePattern pattern;
    Endpoint fromEndpoint;
    String fromRouteId;
    List<Synchronization> onCompletions;
    Boolean externalRedelivered;
    String historyNodeId;
    String historyNodeLabel;
    boolean transacted;
    boolean routeStop;
    boolean rollbackOnly;
    boolean rollbackOnlyLast;
    boolean notifyEvent;
    boolean interrupted;
    boolean interruptable = true;
    boolean redeliveryExhausted;
    Boolean errorHandlerHandled;
    AsyncCallback defaultConsumerCallback;

    public AbstractExchange(CamelContext context) {
        this.context = context;
        this.pattern = ExchangePattern.InOnly;
        this.created = System.currentTimeMillis();
    }

    public AbstractExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
    }

    public AbstractExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.created = parent.getCreated();
        this.fromEndpoint = parent.getFromEndpoint();
        this.fromRouteId = parent.getFromRouteId();
        this.unitOfWork = parent.getUnitOfWork();
    }

    public AbstractExchange(Endpoint fromEndpoint) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = ExchangePattern.InOnly;
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    public AbstractExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
        this.fromEndpoint = fromEndpoint;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public Exchange copy() {
        List history;
        DefaultExchange exchange = new DefaultExchange(this);
        exchange.setIn(this.getIn().copy());
        exchange.getIn().setBody(this.getIn().getBody());
        if (this.getIn().hasHeaders()) {
            exchange.getIn().setHeaders(this.safeCopyHeaders(this.getIn().getHeaders()));
        }
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
            exchange.getOut().setBody(this.getOut().getBody());
            if (this.getOut().hasHeaders()) {
                exchange.getOut().setHeaders(this.safeCopyHeaders(this.getOut().getHeaders()));
            }
        }
        exchange.setException(this.exception);
        exchange.setRouteStop(this.routeStop);
        exchange.setRollbackOnly(this.rollbackOnly);
        exchange.setRollbackOnlyLast(this.rollbackOnlyLast);
        exchange.setNotifyEvent(this.notifyEvent);
        exchange.setRedeliveryExhausted(this.redeliveryExhausted);
        exchange.setErrorHandlerHandled(this.errorHandlerHandled);
        if (this.hasProperties()) {
            this.safeCopyProperties(this.getProperties(), exchange.getProperties());
        }
        System.arraycopy(this.internalProperties, 0, exchange.internalProperties, 0, this.internalProperties.length);
        if (this.getContext().isMessageHistory().booleanValue() && (history = (List)exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()]) != null) {
            exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()] = new CopyOnWriteArrayList(history);
        }
        return exchange;
    }

    private Map<String, Object> safeCopyHeaders(Map<String, Object> headers) {
        ExtendedCamelContext ecc;
        HeadersMapFactory factory;
        if (headers == null) {
            return null;
        }
        if (this.context != null && (factory = (ecc = (ExtendedCamelContext)this.context).getHeadersMapFactory()) != null) {
            return factory.newMap(headers);
        }
        return new HashMap<String, Object>(headers);
    }

    private void safeCopyProperties(Map<String, Object> source, Map<String, Object> target) {
        target.putAll(source);
    }

    @Override
    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getProperty(ExchangePropertyKey key) {
        return this.internalProperties[key.ordinal()];
    }

    @Override
    public <T> T getProperty(ExchangePropertyKey key, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public <T> T getProperty(ExchangePropertyKey key, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public void setProperty(ExchangePropertyKey key, Object value) {
        this.internalProperties[key.ordinal()] = value;
    }

    @Override
    public Object removeProperty(ExchangePropertyKey key) {
        Object old = this.internalProperties[key.ordinal()];
        this.internalProperties[key.ordinal()] = null;
        return old;
    }

    @Override
    public Object getProperty(String name) {
        Object answer = null;
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            answer = this.internalProperties[key.ordinal()];
        }
        if (answer == null && this.properties != null) {
            answer = this.properties.get(name);
        }
        return answer;
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        Object answer = this.getProperty(name);
        return answer != null ? answer : defaultValue;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    @Override
    public void setProperty(String name, Object value) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            this.setProperty(key, value);
        } else if (value != null) {
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<String, Object>(8);
            }
            this.properties.put(name, value);
        } else if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        } else {
            this.properties.clear();
        }
        this.properties.putAll(properties);
    }

    @Override
    public Object removeProperty(String name) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey(name);
        if (key != null) {
            return this.removeProperty(key);
        }
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    @Override
    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    @Override
    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (excludePatterns == null && "*".equals(pattern)) {
            if (this.properties != null) {
                this.properties.clear();
            }
            System.arraycopy(EMPTY_INTERNAL_PROPERTIES, 0, this.internalProperties, 0, INTERNAL_LENGTH);
            return true;
        }
        boolean matches = false;
        for (ExchangePropertyKey epk : ExchangePropertyKey.values()) {
            String key = epk.getName();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.internalProperties[epk.ordinal()] = null;
        }
        if (this.properties != null) {
            HashSet<String> toBeRemoved = null;
            for (String key : this.properties.keySet()) {
                if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
                matches = true;
                if (toBeRemoved == null) {
                    toBeRemoved = new HashSet<String>();
                }
                toBeRemoved.add(key);
            }
            if (matches && toBeRemoved != null) {
                if (toBeRemoved.size() == this.properties.size()) {
                    this.properties.clear();
                } else {
                    for (String key : toBeRemoved) {
                        this.properties.remove(key);
                    }
                }
            }
        }
        return matches;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        }
        return this.properties;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        Map<String, Object> map = this.getInternalProperties();
        if (this.properties != null && !this.properties.isEmpty()) {
            map.putAll(this.properties);
        }
        return map;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return this.context.getTypeConverter().convertTo(type, this, in);
    }

    @Override
    public <T> T getInOrNull(Class<T> type) {
        if (this.in == null) {
            return null;
        }
        if (type.isInstance(this.in)) {
            return type.cast(this.in);
        }
        return null;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    @Override
    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return this.context.getTypeConverter().convertTo(type, this, out);
    }

    @Override
    public boolean hasOut() {
        return this.out != null;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    @Override
    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    @Override
    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    @Override
    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public <T> T getException(Class<T> type) {
        return ObjectHelper.getException(type, this.exception);
    }

    @Override
    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException(this, t));
        if (t instanceof InterruptedException) {
            this.setInterrupted(true);
        }
    }

    @Override
    public <T extends Exchange> T adapt(Class<T> type) {
        return (T)((Exchange)type.cast(this));
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    @Override
    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    @Override
    public String getFromRouteId() {
        return this.fromRouteId;
    }

    @Override
    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    @Override
    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    @Override
    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    @Override
    public boolean isFailed() {
        return this.exception != null;
    }

    @Override
    public boolean isTransacted() {
        return this.transacted;
    }

    @Override
    public void setTransacted(boolean transacted) {
        this.transacted = true;
    }

    @Override
    public boolean isRouteStop() {
        return this.routeStop;
    }

    @Override
    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    @Override
    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == null) {
            Message msg = this.getIn();
            if (msg instanceof DefaultMessage) {
                this.externalRedelivered = ((DefaultMessage)msg).isTransactedRedelivered();
            }
            if (this.externalRedelivered == null) {
                this.externalRedelivered = false;
            }
        }
        return this.externalRedelivered;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    @Override
    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    @Override
    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    @Override
    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    @Override
    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.getUnitOfWork().addSynchronization(onCompletion);
        }
    }

    @Override
    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    @Override
    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                target.adapt(ExtendedExchange.class).addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    @Override
    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    @Override
    public String getHistoryNodeId() {
        return this.historyNodeId;
    }

    @Override
    public void setHistoryNodeId(String historyNodeId) {
        this.historyNodeId = historyNodeId;
    }

    @Override
    public String getHistoryNodeLabel() {
        return this.historyNodeLabel;
    }

    @Override
    public void setHistoryNodeLabel(String historyNodeLabel) {
        this.historyNodeLabel = historyNodeLabel;
    }

    @Override
    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    @Override
    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean interrupted) {
        if (this.interruptable) {
            this.interrupted = interrupted;
        }
    }

    @Override
    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    @Override
    public boolean isRedeliveryExhausted() {
        return this.redeliveryExhausted;
    }

    @Override
    public void setRedeliveryExhausted(boolean redeliveryExhausted) {
        this.redeliveryExhausted = redeliveryExhausted;
    }

    @Override
    public Boolean getErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    @Override
    public boolean isErrorHandlerHandledSet() {
        return this.errorHandlerHandled != null;
    }

    @Override
    public boolean isErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    @Override
    public void setErrorHandlerHandled(Boolean errorHandlerHandled) {
        this.errorHandlerHandled = errorHandlerHandled;
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    @Override
    public void copyInternalProperties(Exchange target) {
        AbstractExchange ae = (AbstractExchange)target;
        for (int i = 0; i < this.internalProperties.length; ++i) {
            Object value = this.internalProperties[i];
            if (value == null) continue;
            ae.internalProperties[i] = value;
        }
    }

    @Override
    public Map<String, Object> getInternalProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ExchangePropertyKey key : ExchangePropertyKey.values()) {
            Object value = this.internalProperties[key.ordinal()];
            if (value == null) continue;
            map.put(key.getName(), value);
        }
        return map;
    }

    @Override
    public AsyncCallback getDefaultConsumerCallback() {
        return this.defaultConsumerCallback;
    }

    @Override
    public void setDefaultConsumerCallback(AsyncCallback defaultConsumerCallback) {
        this.defaultConsumerCallback = defaultConsumerCallback;
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateUuid();
    }

    public String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }
}

