/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core;

import com.googlecode.jsendnsca.core.Encryptor;
import com.googlecode.jsendnsca.core.TripleDESEncryptor;
import com.googlecode.jsendnsca.core.XorEncryptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Encryption {
    NO_ENCRYPTION,
    XOR_ENCRYPTION(1, new XorEncryptor()),
    TRIPLE_DES_ENCRYPTION(3, new TripleDESEncryptor());

    private final int code;
    private final Encryptor encryptor;

    private Encryption() {
        this.code = 0;
        this.encryptor = this.doNothingEncryptor();
    }

    private Encryptor doNothingEncryptor() {
        return new Encryptor(){

            public void encrypt(byte[] passiveCheckBytes, byte[] initVector, String password) {
            }
        };
    }

    private Encryption(int code, Encryptor encryptor) {
        this.code = code;
        this.encryptor = encryptor;
    }

    int getCode() {
        return this.code;
    }

    Encryptor getEncryptor() {
        return this.encryptor;
    }

    static Encryptor getEncryptor(int code) {
        for (Encryption encryption : Encryption.values()) {
            if (encryption.getCode() != code) continue;
            return encryption.getEncryptor();
        }
        throw new IllegalArgumentException(String.format("Code [%d] is not a supported encryption method code", code));
    }
}

