/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core;

import com.googlecode.jsendnsca.core.Level;
import com.googlecode.jsendnsca.core.utils.LevelUtils;
import com.googlecode.jsendnsca.core.utils.StringUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class MessagePayload
implements Serializable {
    public static final int LEVEL_OK = 0;
    public static final int LEVEL_WARNING = 1;
    public static final int LEVEL_CRITICAL = 2;
    public static final int LEVEL_UNKNOWN = 3;
    private static final long serialVersionUID = 6014395299584333124L;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_SERVICENAME = "UNDEFINED";
    private String hostname = "localhost";
    private int level = 3;
    private String serviceName = "UNDEFINED";
    private String message = "";

    public MessagePayload() {
    }

    public MessagePayload(String hostname, int level, String serviceName, String message) {
        if (StringUtils.isBlank(hostname) || StringUtils.isBlank(serviceName)) {
            throw new IllegalArgumentException("hostname or serviceName cannot be null or an empty String");
        }
        this.hostname = hostname;
        this.level = level;
        this.serviceName = serviceName;
        this.message = message;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void useLocalHostname() throws UnknownHostException {
        this.setHostname(false);
    }

    public void setHostname(boolean useCanonical) throws UnknownHostException {
        InetAddress ipAddress = InetAddress.getLocalHost();
        this.hostname = useCanonical ? ipAddress.getCanonicalHostName() : ipAddress.getHostName();
    }

    public void setHostname(String hostname) {
        if (StringUtils.isBlank(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null or an empty String");
        }
        this.hostname = hostname;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (!LevelUtils.isValidLevel(level)) {
            throw new IllegalArgumentException(MessageFormat.format("[{0}] is not a valid level", level));
        }
        this.level = level;
    }

    public void setLevel(String level) {
        this.level = LevelUtils.getLevel(level);
    }

    public void setLevel(Level levelValue) {
        this.level = levelValue.ordinal();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (StringUtils.isBlank(serviceName)) {
            throw new IllegalArgumentException("serviceName cannot be null or an empty String");
        }
        this.serviceName = serviceName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.level;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessagePayload other = (MessagePayload)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
    }

    public String toString() {
        return "MessagePayload[level=" + this.level + ", hostname=" + this.hostname + ", serviceName=" + this.serviceName + ", message=" + this.message + "]";
    }
}

