/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core;

import com.googlecode.jsendnsca.core.Encryption;
import com.googlecode.jsendnsca.core.utils.EncryptionUtils;
import com.googlecode.jsendnsca.core.utils.StringUtils;

public class NagiosSettings {
    public static final int NO_ENCRYPTION = 0;
    public static final int XOR_ENCRYPTION = 1;
    public static final int TRIPLE_DES_ENCRYPTION = 3;
    private String nagiosHost = "localhost";
    private int port = 5667;
    private String password = "password";
    private int timeout = 10000;
    private int connectTimeout = 5000;
    private int encryptionMethod = 1;

    public String getNagiosHost() {
        return this.nagiosHost;
    }

    public void setNagiosHost(String nagiosHost) {
        if (StringUtils.isBlank(nagiosHost)) {
            throw new IllegalArgumentException("nagiosHost cannot be null or empty");
        }
        this.nagiosHost = nagiosHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (StringUtils.isBlank(password)) {
            throw new IllegalArgumentException("password cannot be null or empty");
        }
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(int encryptionMethod) {
        if (!EncryptionUtils.isEncryptionMethodSupported(encryptionMethod)) {
            throw new UnsupportedOperationException("Currently only NO_ENCRYPTION, XOR_ENCRYPTION or TRIPLE_DES_ENCRYPTION Supported");
        }
        this.encryptionMethod = encryptionMethod;
    }

    public void setEncryptionMethod(Encryption encryption) {
        this.encryptionMethod = encryption.getCode();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.encryptionMethod;
        result = 31 * result + (this.nagiosHost == null ? 0 : this.nagiosHost.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NagiosSettings other = (NagiosSettings)obj;
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (this.encryptionMethod != other.encryptionMethod) {
            return false;
        }
        if (this.nagiosHost == null ? other.nagiosHost != null : !this.nagiosHost.equals(other.nagiosHost)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.timeout == other.timeout;
    }
}

