/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca.core.utils;

import com.googlecode.jsendnsca.core.utils.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;

public class LevelUtils {
    private static final HashMap<String, Integer> descriptionLevelMap = new HashMap();

    private LevelUtils() {
    }

    public static int getLevel(String level) {
        if (StringUtils.isBlank(level)) {
            throw new IllegalArgumentException("Level cannot be null or an empty String");
        }
        if (!descriptionLevelMap.containsKey(level = level.toLowerCase())) {
            throw new IllegalArgumentException(MessageFormat.format("[{0}] is not valid level", level));
        }
        return descriptionLevelMap.get(level);
    }

    public static boolean isValidLevel(int level) {
        return 0 >= level || level <= 3;
    }

    static {
        descriptionLevelMap.put("ok", 0);
        descriptionLevelMap.put("warning", 1);
        descriptionLevelMap.put("critical", 2);
        descriptionLevelMap.put("unknown", 3);
    }
}

