/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nats.NatsComponent;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsConsumer;
import org.apache.camel.component.nats.NatsProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.17.0", scheme="nats", title="Nats", syntax="nats:servers", label="messaging", consumerClass=NatsConsumer.class)
public class NatsEndpoint
extends DefaultEndpoint {
    @UriParam
    private NatsConfiguration configuration;

    public NatsEndpoint(String uri, NatsComponent component, NatsConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        return new NatsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new NatsConsumer(this, processor);
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "NatsTopic[" + this.configuration.getTopic() + "]", this.configuration.getPoolSize());
    }

    public boolean isSingleton() {
        return true;
    }

    public NatsConfiguration getNatsConfiguration() {
        return this.configuration;
    }

    public Connection getConnection() throws InterruptedException, IllegalArgumentException, GeneralSecurityException, IOException {
        Options.Builder builder = this.getNatsConfiguration().createOptions();
        if (this.getNatsConfiguration().getSslContextParameters() != null && this.getNatsConfiguration().isSecure()) {
            SSLContext sslCtx = this.getNatsConfiguration().getSslContextParameters().createSSLContext(this.getCamelContext());
            builder.sslContext(sslCtx);
        }
        Options options = builder.build();
        return Nats.connect(options);
    }
}

