/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.ObjectInput;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;

@DeferredContextBinding
public final class NettyConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        NettyConverterLoader.addTypeConverter(registry, byte[].class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toByteArray((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, ByteBuf.class, byte[].class, false, (type, exchange, value) -> NettyConverter.toByteBuffer((byte[])value));
        NettyConverterLoader.addTypeConverter(registry, ByteBuf.class, String.class, false, (type, exchange, value) -> NettyConverter.toByteBuffer((String)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, InputStream.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toInputStream((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, ObjectInput.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toObjectInput((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, String.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toString((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, DOMSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toDOMSource((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, SAXSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toSAXSource((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, StAXSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toStAXSource((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, StreamSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toStreamSource((ByteBuf)value, exchange));
        NettyConverterLoader.addTypeConverter(registry, Document.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toDocument((ByteBuf)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }
}

