/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.NoSuchElementException;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSingletonObjectPool<T>
implements ObjectPool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSingletonObjectPool.class);
    private final PooledObjectFactory<T> factory;
    private volatile PooledObject<T> t;

    public SharedSingletonObjectPool(PooledObjectFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
    }

    @Override
    public synchronized T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
        if (this.t != null && !this.factory.validateObject(this.t)) {
            this.invalidateObject(this.t.getObject());
            LOG.info("Recreating new connection as current connection is invalid: {}", this.t);
            this.t = null;
        }
        if (this.t == null) {
            this.t = this.factory.makeObject();
        }
        return this.t.getObject();
    }

    @Override
    public void clear() throws Exception, UnsupportedOperationException {
        this.t = null;
    }

    @Override
    public void close() {
        this.t = null;
    }

    @Override
    public int getNumActive() {
        return 1;
    }

    @Override
    public int getNumIdle() {
        return 0;
    }

    @Override
    public void invalidateObject(T obj) throws Exception {
        this.t = null;
    }

    @Override
    public void returnObject(T obj) throws Exception {
    }
}

