/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.concurrent.Executors;
import org.apache.camel.component.netty.CamelNettyThreadNameDeterminer;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.util.HashedWheelTimer;

public final class NettyClientBossPoolBuilder {
    private String name = "NettyClientBoss";
    private String pattern;
    private int bossCount = 1;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public NettyClientBossPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyClientBossPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyClientBossPoolBuilder withBossCount(int bossCount) {
        this.setBossCount(bossCount);
        return this;
    }

    BossPool build() {
        return new NioClientBossPool(Executors.newCachedThreadPool(), this.bossCount, new HashedWheelTimer(), new CamelNettyThreadNameDeterminer(this.pattern, this.name));
    }
}

