/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.camel.component.netty.CamelNettyThreadNameDeterminer;
import org.apache.camel.component.netty.NettyHelper;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;

public final class NettyWorkerPoolBuilder {
    private String name = "NettyWorker";
    private String pattern;
    private int workerCount;
    private volatile WorkerPool workerPool;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public NettyWorkerPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyWorkerPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyWorkerPoolBuilder withWorkerCount(int workerCount) {
        this.setWorkerCount(workerCount);
        return this;
    }

    WorkerPool build() {
        int count = this.workerCount > 0 ? this.workerCount : NettyHelper.DEFAULT_IO_THREADS;
        this.workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(), count, new CamelNettyThreadNameDeterminer(this.pattern, this.name));
        return this.workerPool;
    }

    public void destroy() {
        if (this.workerPool != null) {
            this.workerPool.shutdown();
            this.workerPool = null;
        }
    }
}

