/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.SingleTCPNettyServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerBootstrapFactory
extends SingleTCPNettyServerBootstrapFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerBootstrapFactory.class);
    private final HttpServerConsumerChannelFactory channelFactory;
    private int port;
    private NettyServerBootstrapConfiguration bootstrapConfiguration;
    private boolean compatibleCheck;

    public HttpServerBootstrapFactory(HttpServerConsumerChannelFactory channelFactory) {
        this(channelFactory, true);
    }

    public HttpServerBootstrapFactory(HttpServerConsumerChannelFactory channelFactory, boolean compatibleCheck) {
        this.channelFactory = channelFactory;
        this.compatibleCheck = compatibleCheck;
    }

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelPipelineFactory pipelineFactory) {
        super.init(camelContext, configuration, pipelineFactory);
        this.port = configuration.getPort();
        this.bootstrapConfiguration = configuration;
        LOG.info("BootstrapFactory on port {} is using bootstrap configuration: [{}]", (Object)this.port, (Object)this.bootstrapConfiguration.toStringBootstrapConfiguration());
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
        if (this.compatibleCheck && this.bootstrapConfiguration != consumer.getConfiguration() && !this.bootstrapConfiguration.compatible(consumer.getConfiguration())) {
            throw new IllegalArgumentException("Bootstrap configuration must be identical when adding additional consumer: " + (Object)((Object)consumer.getEndpoint()) + " on same port: " + this.port + ".\n  Existing " + this.bootstrapConfiguration.toStringBootstrapConfiguration() + "\n       New " + consumer.getConfiguration().toStringBootstrapConfiguration());
        }
        if (LOG.isDebugEnabled()) {
            NettyHttpConsumer httpConsumer = (NettyHttpConsumer)consumer;
            LOG.debug("BootstrapFactory on port {} is adding consumer with context-path {}", (Object)this.port, (Object)httpConsumer.getConfiguration().getPath());
        }
        this.channelFactory.addConsumer((NettyHttpConsumer)consumer);
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
        if (LOG.isDebugEnabled()) {
            NettyHttpConsumer httpConsumer = (NettyHttpConsumer)consumer;
            LOG.debug("BootstrapFactory on port {} is removing consumer with context-path {}", (Object)this.port, (Object)httpConsumer.getConfiguration().getPath());
        }
        this.channelFactory.removeConsumer((NettyHttpConsumer)consumer);
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("BootstrapFactory on port {} is starting", (Object)this.port);
        super.doStart();
    }

    public void stop() throws Exception {
        int consumers = this.channelFactory.consumers();
        if (consumers == 0) {
            LOG.debug("BootstrapFactory on port {} is stopping", (Object)this.port);
            super.stop();
        } else {
            LOG.debug("BootstrapFactory on port {} has {} registered consumers, so cannot stop yet.", (Object)this.port, (Object)consumers);
        }
    }
}

