/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerPipelineFactory
extends ServerPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerPipelineFactory.class);
    protected NettyHttpConsumer consumer;
    protected SSLContext sslContext;
    protected NettyServerBootstrapConfiguration configuration;

    public HttpServerPipelineFactory() {
    }

    public HttpServerPipelineFactory(NettyHttpConsumer nettyConsumer) {
        this.consumer = nettyConsumer;
        this.configuration = nettyConsumer.getConfiguration();
        try {
            this.sslContext = this.createSSLContext(this.consumer.getContext(), this.consumer.getConfiguration());
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    @Override
    public ServerPipelineFactory createPipelineFactory(NettyConsumer nettyConsumer) {
        return new HttpServerPipelineFactory((NettyHttpConsumer)nettyConsumer);
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            sslHandler.setCloseOnSSLException(true);
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", sslHandler);
        }
        pipeline.addLast("decoder", new HttpRequestDecoder());
        pipeline.addLast("aggregator", new HttpChunkAggregator(0x100000));
        pipeline.addLast("encoder", new HttpResponseEncoder());
        if (this.supportCompressed()) {
            pipeline.addLast("deflater", new HttpContentCompressor());
        }
        if (this.consumer.getConfiguration().isOrderedThreadPoolExecutor()) {
            ExecutionHandler executionHandler = new ExecutionHandler(this.consumer.getEndpoint().getComponent().getExecutorService());
            pipeline.addLast("executionHandler", executionHandler);
            LOG.debug("Using OrderedMemoryAwareThreadPoolExecutor with core pool size: {}", (Object)this.consumer.getConfiguration().getMaximumPoolSize());
        }
        int port = this.consumer.getConfiguration().getPort();
        ChannelHandler handler = this.consumer.getEndpoint().getComponent().getMultiplexChannelHandler(port).getChannelHandler();
        pipeline.addLast("handler", handler);
        return pipeline;
    }

    private SSLContext createSSLContext(CamelContext camelContext, NettyServerBootstrapConfiguration configuration) throws Exception {
        SSLContext answer;
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext();
        } else {
            if (configuration.getKeyStoreFile() == null && configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (configuration.getTrustStoreFile() == null && configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(camelContext.getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(camelContext.getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (!this.consumer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.consumer.getConfiguration().getSslHandler() != null) {
            return this.consumer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.consumer.getConfiguration().isNeedClientAuth());
            return new SslHandler(engine);
        }
        return null;
    }

    private boolean supportCompressed() {
        return this.consumer.getEndpoint().getConfiguration().isCompression();
    }
}

