/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.DefaultNettyHttpBinding;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerPipelineFactory;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.component.netty.http.handlers.HttpServerMultiplexChannelHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpComponent
extends NettyComponent
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpComponent.class);
    private final Map<Integer, HttpServerConsumerChannelFactory> multiplexChannelHandlers = new HashMap<Integer, HttpServerConsumerChannelFactory>();
    private final Map<String, HttpServerBootstrapFactory> bootstrapFactories = new HashMap<String, HttpServerBootstrapFactory>();
    private NettyHttpBinding nettyHttpBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private NettyHttpSecurityConfiguration securityConfiguration;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HashMap options;
        NettyConfiguration config = this.getConfiguration() != null ? this.getConfiguration().copy() : new NettyHttpConfiguration();
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null && IntrospectionSupport.getProperties((Object)bootstrapConfiguration, options = new HashMap(), null, (boolean)false)) {
            IntrospectionSupport.setProperties((TypeConverter)this.getCamelContext().getTypeConverter(), (Object)config, options);
        }
        NettyHttpSecurityConfiguration securityConfiguration = (NettyHttpSecurityConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "securityConfiguration", NettyHttpSecurityConfiguration.class);
        Map securityOptions = IntrospectionSupport.extractProperties(parameters, (String)"securityConfiguration.");
        config = this.parseConfiguration(config, remaining, parameters);
        this.setProperties(config, parameters);
        config.validateConfiguration();
        NettySharedHttpServer shared = (NettySharedHttpServer)this.resolveAndRemoveReferenceParameter(parameters, "nettySharedHttpServer", NettySharedHttpServer.class);
        if (shared != null) {
            LOG.debug("Using NettySharedHttpServer: {} with port: {}", (Object)shared, (Object)shared.getPort());
            config.setPort(shared.getPort());
        }
        URI u = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        String addressUri = URISupport.createRemainingURI((URI)u, parameters).toString();
        NettyHttpEndpoint answer = new NettyHttpEndpoint(addressUri, this, config);
        answer.setTimer(NettyHttpComponent.getTimer());
        if (answer.getNettyHttpBinding() == null) {
            answer.setNettyHttpBinding(this.getNettyHttpBinding());
        }
        if (answer.getHeaderFilterStrategy() == null) {
            answer.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (securityConfiguration != null) {
            answer.setSecurityConfiguration(securityConfiguration);
        } else if (answer.getSecurityConfiguration() == null) {
            answer.setSecurityConfiguration(this.getSecurityConfiguration());
        }
        if (securityOptions != null && !securityOptions.isEmpty()) {
            securityConfiguration = answer.getSecurityConfiguration();
            if (securityConfiguration == null) {
                securityConfiguration = new NettyHttpSecurityConfiguration();
                answer.setSecurityConfiguration(securityConfiguration);
            }
            this.setProperties(securityConfiguration, securityOptions);
            this.validateParameters(uri, securityOptions, null);
        }
        answer.setNettySharedHttpServer(shared);
        return answer;
    }

    @Override
    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        String safe = UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining);
        URI uri = new URI(safe);
        configuration.parseURI(uri, parameters, this, "http", "https");
        configuration.setProtocol("tcp");
        configuration.setTextline(false);
        if (configuration instanceof NettyHttpConfiguration) {
            ((NettyHttpConfiguration)configuration).setPath(uri.getPath());
        }
        return configuration;
    }

    public NettyHttpBinding getNettyHttpBinding() {
        if (this.nettyHttpBinding == null) {
            this.nettyHttpBinding = new DefaultNettyHttpBinding(this.getHeaderFilterStrategy());
        }
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new NettyHttpHeaderFilterStrategy();
        }
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public synchronized HttpServerConsumerChannelFactory getMultiplexChannelHandler(int port) {
        HttpServerConsumerChannelFactory answer = this.multiplexChannelHandlers.get(port);
        if (answer == null) {
            answer = new HttpServerMultiplexChannelHandler();
            answer.init(port);
            this.multiplexChannelHandlers.put(port, answer);
        }
        return answer;
    }

    protected synchronized HttpServerBootstrapFactory getOrCreateHttpNettyServerBootstrapFactory(NettyHttpConsumer consumer) {
        String key = consumer.getConfiguration().getAddress();
        HttpServerBootstrapFactory answer = this.bootstrapFactories.get(key);
        if (answer == null) {
            HttpServerConsumerChannelFactory channelFactory = this.getMultiplexChannelHandler(consumer.getConfiguration().getPort());
            answer = new HttpServerBootstrapFactory(channelFactory);
            answer.init(this.getCamelContext(), (NettyServerBootstrapConfiguration)consumer.getConfiguration(), (ChannelPipelineFactory)new HttpServerPipelineFactory(consumer));
            this.bootstrapFactories.put(key, answer);
        }
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getConfiguration() == null) {
            this.setConfiguration(new NettyHttpConfiguration());
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopServices(this.bootstrapFactories.values());
        this.bootstrapFactories.clear();
        ServiceHelper.stopService(this.multiplexChannelHandlers.values());
        this.multiplexChannelHandlers.clear();
    }
}

