/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ChannelHandlerFactories;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.ServerPipelineFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfiguration
extends NettyServerBootstrapConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfiguration.class);
    private long requestTimeout;
    private boolean sync = true;
    private boolean textline;
    private TextLineDelimiter delimiter = TextLineDelimiter.LINE;
    private boolean autoAppendDelimiter = true;
    private int decoderMaxLineLength = 1024;
    private String encoding;
    private List<ChannelHandler> encoders = new ArrayList<ChannelHandler>();
    private List<ChannelHandler> decoders = new ArrayList<ChannelHandler>();
    private boolean disconnect;
    private boolean lazyChannelCreation = true;
    private boolean transferExchange;
    private boolean disconnectOnNoReply = true;
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    private LoggingLevel serverExceptionCaughtLogLevel = LoggingLevel.WARN;
    private LoggingLevel serverClosedChannelExceptionCaughtLogLevel = LoggingLevel.DEBUG;
    private boolean allowDefaultCodec = true;
    private ClientPipelineFactory clientPipelineFactory;
    private int maximumPoolSize = 16;
    private boolean orderedThreadPoolExecutor = true;
    private int producerPoolMaxActive = -1;
    private int producerPoolMinIdle;
    private int producerPoolMaxIdle = 100;
    private long producerPoolMinEvictableIdle = 300000L;
    private boolean producerPoolEnabled = true;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            ArrayList<ChannelHandler> encodersCopy = new ArrayList<ChannelHandler>(this.encoders);
            answer.setEncoders(encodersCopy);
            ArrayList<ChannelHandler> decodersCopy = new ArrayList<ChannelHandler>(this.decoders);
            answer.setDecoders(decodersCopy);
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void validateConfiguration() {
        for (ChannelHandler encoder : this.encoders) {
            if (encoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)encoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The encoder {} is not @Shareable or an ChannelHandlerFactory instance. The encoder cannot safely be used.", (Object)encoder);
        }
        for (ChannelHandler decoder : this.decoders) {
            if (decoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)decoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The decoder {} is not @Shareable or an ChannelHandlerFactory instance. The decoder cannot safely be used.", (Object)decoder);
        }
        if (this.sslHandler != null) {
            boolean shareable;
            boolean factory = this.sslHandler instanceof ChannelHandlerFactory;
            boolean bl = shareable = ObjectHelper.getAnnotation((Object)this.sslHandler, ChannelHandler.Sharable.class) != null;
            if (!factory && !shareable) {
                LOG.warn("The sslHandler {} is not @Shareable or an ChannelHandlerFactory instance. The sslHandler cannot safely be used.", (Object)this.sslHandler);
            }
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component, String ... supportedProtocols) throws Exception {
        this.protocol = uri.getScheme();
        boolean found = false;
        for (String supportedProtocol : supportedProtocols) {
            if (this.protocol == null || !this.protocol.equalsIgnoreCase(supportedProtocol)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.ssl = (Boolean)component.getAndRemoveOrResolveReferenceParameter(parameters, "ssl", Boolean.TYPE, false);
        this.sslHandler = (SslHandler)component.getAndRemoveOrResolveReferenceParameter(parameters, "sslHandler", SslHandler.class, this.sslHandler);
        this.passphrase = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "passphrase", String.class, this.passphrase);
        this.keyStoreFormat = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "keyStoreFormat", String.class, this.keyStoreFormat == null ? "JKS" : this.keyStoreFormat);
        this.securityProvider = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "securityProvider", String.class, this.securityProvider == null ? "SunX509" : this.securityProvider);
        this.keyStoreFile = (File)component.getAndRemoveOrResolveReferenceParameter(parameters, "keyStoreFile", File.class, this.keyStoreFile);
        this.trustStoreFile = (File)component.getAndRemoveOrResolveReferenceParameter(parameters, "trustStoreFile", File.class, this.trustStoreFile);
        this.keyStoreResource = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "keyStoreResource", String.class, this.keyStoreResource);
        this.trustStoreResource = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "trustStoreResource", String.class, this.trustStoreResource);
        this.clientPipelineFactory = (ClientPipelineFactory)component.getAndRemoveOrResolveReferenceParameter(parameters, "clientPipelineFactory", ClientPipelineFactory.class, this.clientPipelineFactory);
        this.serverPipelineFactory = (ServerPipelineFactory)component.getAndRemoveOrResolveReferenceParameter(parameters, "serverPipelineFactory", ServerPipelineFactory.class, this.serverPipelineFactory);
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.encoders, referencedEncoders, ChannelHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.decoders, referencedDecoders, ChannelHandler.class);
        EndpointHelper.setReferenceProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        EndpointHelper.setProperties((CamelContext)component.getCamelContext(), (Object)this, parameters);
        this.options = IntrospectionSupport.extractProperties(parameters, (String)"option.");
        if (this.options != null && this.options.isEmpty()) {
            this.options = null;
        }
        if (this.encoders.isEmpty() && this.decoders.isEmpty()) {
            if (this.isAllowDefaultCodec()) {
                if (this.isTextline()) {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encoders.add(ChannelHandlerFactories.newStringEncoder(charset));
                    ChannelBuffer[] delimiters = this.delimiter == TextLineDelimiter.LINE ? Delimiters.lineDelimiter() : Delimiters.nulDelimiter();
                    this.decoders.add(ChannelHandlerFactories.newDelimiterBasedFrameDecoder(this.decoderMaxLineLength, delimiters));
                    this.decoders.add(ChannelHandlerFactories.newStringDecoder(charset));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using textline encoders and decoders with charset: {}, delimiter: {} and decoderMaxLineLength: {}", new Object[]{charset, this.delimiter, this.decoderMaxLineLength});
                    }
                } else {
                    this.encoders.add(ChannelHandlerFactories.newObjectEncoder());
                    this.decoders.add(ChannelHandlerFactories.newObjectDecoder());
                    LOG.debug("Using object encoders and decoders");
                }
            } else {
                LOG.debug("No encoders and decoders will be used");
            }
        } else {
            LOG.debug("Using configured encoders and/or decoders");
        }
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public TextLineDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(TextLineDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isAutoAppendDelimiter() {
        return this.autoAppendDelimiter;
    }

    public void setAutoAppendDelimiter(boolean autoAppendDelimiter) {
        this.autoAppendDelimiter = autoAppendDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<ChannelHandler> getDecoders() {
        return this.decoders;
    }

    public void setDecoders(List<ChannelHandler> decoders) {
        this.decoders = decoders;
    }

    public List<ChannelHandler> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(List<ChannelHandler> encoders) {
        this.encoders = encoders;
    }

    public ChannelHandler getEncoder() {
        return this.encoders.isEmpty() ? null : this.encoders.get(0);
    }

    public void setEncoder(ChannelHandler encoder) {
        if (!this.encoders.contains(encoder)) {
            this.encoders.add(encoder);
        }
    }

    public ChannelHandler getDecoder() {
        return this.decoders.isEmpty() ? null : this.decoders.get(0);
    }

    public void setDecoder(ChannelHandler decoder) {
        if (!this.decoders.contains(decoder)) {
            this.decoders.add(decoder);
        }
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public LoggingLevel getServerExceptionCaughtLogLevel() {
        return this.serverExceptionCaughtLogLevel;
    }

    public void setServerExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
        this.serverExceptionCaughtLogLevel = serverExceptionCaughtLogLevel;
    }

    public LoggingLevel getServerClosedChannelExceptionCaughtLogLevel() {
        return this.serverClosedChannelExceptionCaughtLogLevel;
    }

    public void setServerClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
        this.serverClosedChannelExceptionCaughtLogLevel = serverClosedChannelExceptionCaughtLogLevel;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public void setClientPipelineFactory(ClientPipelineFactory clientPipelineFactory) {
        this.clientPipelineFactory = clientPipelineFactory;
    }

    public ClientPipelineFactory getClientPipelineFactory() {
        return this.clientPipelineFactory;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public boolean isOrderedThreadPoolExecutor() {
        return this.orderedThreadPoolExecutor;
    }

    public void setOrderedThreadPoolExecutor(boolean orderedThreadPoolExecutor) {
        this.orderedThreadPoolExecutor = orderedThreadPoolExecutor;
    }

    public int getProducerPoolMaxActive() {
        return this.producerPoolMaxActive;
    }

    public void setProducerPoolMaxActive(int producerPoolMaxActive) {
        this.producerPoolMaxActive = producerPoolMaxActive;
    }

    public int getProducerPoolMinIdle() {
        return this.producerPoolMinIdle;
    }

    public void setProducerPoolMinIdle(int producerPoolMinIdle) {
        this.producerPoolMinIdle = producerPoolMinIdle;
    }

    public int getProducerPoolMaxIdle() {
        return this.producerPoolMaxIdle;
    }

    public void setProducerPoolMaxIdle(int producerPoolMaxIdle) {
        this.producerPoolMaxIdle = producerPoolMaxIdle;
    }

    public long getProducerPoolMinEvictableIdle() {
        return this.producerPoolMinEvictableIdle;
    }

    public void setProducerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
        this.producerPoolMinEvictableIdle = producerPoolMinEvictableIdle;
    }

    public boolean isProducerPoolEnabled() {
        return this.producerPoolEnabled;
    }

    public void setProducerPoolEnabled(boolean producerPoolEnabled) {
        this.producerPoolEnabled = producerPoolEnabled;
    }

    private static <T> void addToHandlersList(List<T> configured, List<T> handlers, Class<T> handlerType) {
        if (handlers != null) {
            for (T handler : handlers) {
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }
}

