/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http.handlers;

import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.handlers.ServerChannelHandler;
import org.apache.camel.component.netty.http.HttpPrincipal;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.SecurityAuthenticator;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerChannelHandler
extends ServerChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private final NettyHttpConsumer consumer;
    private HttpRequest request;

    public HttpServerChannelHandler(NettyHttpConsumer consumer) {
        super(consumer);
        this.consumer = consumer;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        this.request = (HttpRequest)messageEvent.getMessage();
        LOG.debug("Message received: {}", (Object)this.request);
        if (this.consumer.isSuspended()) {
            LOG.debug("Consumer suspended, cannot service request {}", (Object)this.request);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE);
            response.setChunked(false);
            response.setHeader("Content-Type", "text/plain");
            response.setHeader("Content-Length", 0);
            response.setContent(ChannelBuffers.copiedBuffer(new byte[0]));
            messageEvent.getChannel().write(response).syncUninterruptibly();
            messageEvent.getChannel().close();
            return;
        }
        if (this.consumer.getEndpoint().getHttpMethodRestrict() != null && !this.consumer.getEndpoint().getHttpMethodRestrict().contains(this.request.getMethod().getName())) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            response.setChunked(false);
            response.setHeader("Content-Type", "text/plain");
            response.setHeader("Content-Length", 0);
            response.setContent(ChannelBuffers.copiedBuffer(new byte[0]));
            messageEvent.getChannel().write(response).syncUninterruptibly();
            messageEvent.getChannel().close();
            return;
        }
        if ("TRACE".equals(this.request.getMethod().getName()) && !this.consumer.getEndpoint().isTraceEnabled()) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            response.setChunked(false);
            response.setHeader("Content-Type", "text/plain");
            response.setHeader("Content-Length", 0);
            response.setContent(ChannelBuffers.copiedBuffer(new byte[0]));
            messageEvent.getChannel().write(response).syncUninterruptibly();
            messageEvent.getChannel().close();
            return;
        }
        if (!this.request.getHeaderNames().contains("Host")) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            response.setChunked(false);
            response.setHeader("Content-Type", "text/plain");
            response.setHeader("Content-Length", 0);
            response.setContent(ChannelBuffers.copiedBuffer(new byte[0]));
            messageEvent.getChannel().write(response).syncUninterruptibly();
            messageEvent.getChannel().close();
            return;
        }
        NettyHttpSecurityConfiguration security = this.consumer.getEndpoint().getSecurityConfiguration();
        if (security != null && security.isAuthenticate() && "Basic".equalsIgnoreCase(security.getConstraint())) {
            String roles;
            String url = this.request.getUri();
            if (url.contains("?")) {
                url = ObjectHelper.before((String)url, (String)"?");
            }
            URI uri = new URI(this.request.getUri());
            String target = uri.getPath();
            String path = this.consumer.getConfiguration().getPath();
            if (path != null && target.startsWith(path)) {
                target = target.substring(path.length());
            }
            if ((roles = security.getSecurityConstraint() != null ? security.getSecurityConstraint().restricted(target) : "*") != null) {
                HttpPrincipal principal = HttpServerChannelHandler.extractBasicAuthSubject(this.request);
                Subject subject = null;
                boolean inRole = true;
                if (principal != null && (subject = this.authenticate(security.getSecurityAuthenticator(), security.getLoginDeniedLoggingLevel(), principal)) != null) {
                    String userRoles = security.getSecurityAuthenticator().getUserRoles(subject);
                    inRole = this.matchesRoles(roles, userRoles);
                }
                if (principal == null || subject == null || !inRole) {
                    if (principal == null) {
                        LOG.debug("Http Basic Auth required for resource: {}", (Object)url);
                    } else if (subject == null) {
                        LOG.debug("Http Basic Auth not authorized for username: {}", (Object)principal.getUsername());
                    } else {
                        LOG.debug("Http Basic Auth not in role for username: {}", (Object)principal.getUsername());
                    }
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                    response.setHeader("WWW-Authenticate", "Basic realm=\"" + security.getRealm() + "\"");
                    response.setHeader("Content-Type", "text/plain");
                    response.setHeader("Content-Length", 0);
                    response.setContent(ChannelBuffers.copiedBuffer(new byte[0]));
                    messageEvent.getChannel().write(response).syncUninterruptibly();
                    messageEvent.getChannel().close();
                    return;
                }
                LOG.debug("Http Basic Auth authorized for username: {}", (Object)principal.getUsername());
            }
        }
        super.messageReceived(ctx, messageEvent);
    }

    protected boolean matchesRoles(String roles, String userRoles) {
        if (roles.equals("*")) {
            return true;
        }
        Iterator it = ObjectHelper.createIterator((Object)userRoles);
        while (it.hasNext()) {
            String userRole = it.next().toString();
            if (!roles.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    protected static HttpPrincipal extractBasicAuthSubject(HttpRequest request) {
        String constraint;
        String auth = request.getHeader("Authorization");
        if (auth != null && (constraint = ObjectHelper.before((String)auth, (String)" ")) != null && "Basic".equalsIgnoreCase(constraint.trim())) {
            String decoded = ObjectHelper.after((String)auth, (String)" ");
            ChannelBuffer buf = ChannelBuffers.copiedBuffer(decoded.getBytes());
            ChannelBuffer out = Base64.decode(buf);
            String userAndPw = out.toString(Charset.defaultCharset());
            String username = ObjectHelper.before((String)userAndPw, (String)":");
            String password = ObjectHelper.after((String)userAndPw, (String)":");
            HttpPrincipal principal = new HttpPrincipal(username, password);
            LOG.debug("Extracted Basic Auth principal from HTTP header: {}", (Object)principal);
            return principal;
        }
        return null;
    }

    protected Subject authenticate(SecurityAuthenticator authenticator, LoggingLevel deniedLoggingLevel, HttpPrincipal principal) {
        try {
            return authenticator.login(principal);
        }
        catch (LoginException e) {
            CamelLogger logger = new CamelLogger(LOG, deniedLoggingLevel);
            logger.log("Cannot login " + principal.getName() + " due " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void beforeProcess(Exchange exchange, MessageEvent messageEvent) {
        if (this.consumer.getConfiguration().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (this.consumer.isRunAllowed()) {
            if (exceptionEvent.getCause() instanceof ClosedChannelException) {
                LOG.debug("Channel already closed. Ignoring this exception.");
            } else {
                LOG.warn("Closing channel as an exception was thrown from Netty", exceptionEvent.getCause());
                NettyHelper.close(exceptionEvent.getChannel());
            }
        }
    }

    @Override
    protected Object getResponseBody(Exchange exchange) throws Exception {
        if (exchange.hasOut()) {
            return this.consumer.getEndpoint().getNettyHttpBinding().toNettyResponse(exchange.getOut(), this.consumer.getConfiguration());
        }
        return this.consumer.getEndpoint().getNettyHttpBinding().toNettyResponse(exchange.getIn(), this.consumer.getConfiguration());
    }
}

