/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty4.ChannelHandlerFactory;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty4.ServerInitializerFactory;
import org.apache.camel.component.netty4.handlers.ServerChannelHandler;
import org.apache.camel.component.netty4.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerInitializerFactory
extends ServerInitializerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerInitializerFactory.class);
    private NettyConsumer consumer;
    private SSLContext sslContext;

    @Deprecated
    public DefaultServerInitializerFactory(NettyServerBootstrapConfiguration configuration) {
        this.consumer = null;
        try {
            this.sslContext = this.createSSLContext(null, configuration);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    public DefaultServerInitializerFactory(NettyConsumer consumer) {
        this.consumer = consumer;
        try {
            this.sslContext = this.createSSLContext(consumer.getContext(), consumer.getConfiguration());
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline channelPipeline = ch.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            this.addToPipeline("ssl", channelPipeline, sslHandler);
        }
        List<ChannelHandler> encoders = this.consumer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            this.addToPipeline("encoder-" + x, channelPipeline, encoder);
        }
        List<ChannelHandler> decoders = this.consumer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            this.addToPipeline("decoder-" + x, channelPipeline, decoder);
        }
        if (this.consumer.getConfiguration().isUsingExecutorService()) {
            EventExecutorGroup applicationExecutor = this.consumer.getEndpoint().getComponent().getExecutorService();
            this.addToPipeline("handler", channelPipeline, applicationExecutor, new ServerChannelHandler(this.consumer));
        } else {
            this.addToPipeline("handler", channelPipeline, new ServerChannelHandler(this.consumer));
        }
        LOG.trace("Created ChannelPipeline: {}", (Object)channelPipeline);
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, ChannelHandler handler) {
        pipeline.addLast(name, handler);
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, EventExecutorGroup executor, ChannelHandler handler) {
        pipeline.addLast(executor, name, handler);
    }

    private SSLContext createSSLContext(CamelContext camelContext, NettyServerBootstrapConfiguration configuration) throws Exception {
        SSLContext answer;
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext(camelContext);
        } else {
            if (configuration.getKeyStoreFile() == null && configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (configuration.getTrustStoreFile() == null && configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(camelContext.getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(camelContext.getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (!this.consumer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.consumer.getConfiguration().getSslHandler() != null) {
            return this.consumer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(this.consumer.getConfiguration().isClientMode());
            engine.setNeedClientAuth(this.consumer.getConfiguration().isNeedClientAuth());
            if (this.consumer.getConfiguration().getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.consumer.getConfiguration().getEnabledProtocols().split(","));
            }
            return new SslHandler(engine);
        }
        return null;
    }

    @Override
    public ServerInitializerFactory createPipelineFactory(NettyConsumer consumer) {
        return new DefaultServerInitializerFactory(consumer);
    }
}

