/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty4.codec.DelegateByteArrayDecoder;

@ChannelHandler.Sharable
public class DatagramPacketByteArrayDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private DelegateByteArrayDecoder delegateDecoder = new DelegateByteArrayDecoder();

    @Override
    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            this.delegateDecoder.decode(ctx, (ByteBuf)msg.content(), out);
            byte[] content = (byte[])out.remove(out.size() - 1);
            DefaultAddressedEnvelope<byte[], InetSocketAddress> addressedEnvelop = new DefaultAddressedEnvelope<byte[], InetSocketAddress>(content, msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        }
    }
}

