/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.NettyEndpoint;
import org.apache.camel.impl.DefaultExchangeHolder;

public final class NettyPayloadHelper {
    private NettyPayloadHelper() {
    }

    public static Object getIn(NettyEndpoint endpoint, Exchange exchange) {
        if (endpoint.getConfiguration().isTransferExchange()) {
            return DefaultExchangeHolder.marshal((Exchange)exchange);
        }
        if (endpoint.getConfiguration().isUseByteBuf()) {
            return exchange.getIn().getBody(ByteBuf.class);
        }
        return exchange.getIn().getBody();
    }

    public static Object getOut(NettyEndpoint endpoint, Exchange exchange) {
        if (endpoint.getConfiguration().isTransferExchange()) {
            return DefaultExchangeHolder.marshal((Exchange)exchange);
        }
        return exchange.getOut().getBody();
    }

    public static void setIn(Exchange exchange, Object payload) {
        if (payload instanceof DefaultExchangeHolder) {
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)payload));
        } else if (payload instanceof AddressedEnvelope) {
            AddressedEnvelope dp = (AddressedEnvelope)payload;
            if (dp.content() instanceof DefaultExchangeHolder) {
                DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)dp.content()));
            } else {
                exchange.getIn().setBody(dp.content());
            }
            exchange.setProperty("CamelNettyRemoteAddress", dp.sender());
            exchange.getIn().setHeader("CamelNettyRemoteAddress", dp.sender());
        } else {
            exchange.getIn().setBody(payload);
        }
    }

    public static void setOut(Exchange exchange, Object payload) {
        if (payload instanceof DefaultExchangeHolder) {
            DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)payload));
        } else if (payload instanceof AddressedEnvelope) {
            AddressedEnvelope dp = (AddressedEnvelope)payload;
            if (dp.content() instanceof DefaultExchangeHolder) {
                DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)((DefaultExchangeHolder)dp.content()));
            } else {
                exchange.getOut().setBody(dp.content());
            }
            exchange.setProperty("CamelNettyRemoteAddress", dp.sender());
        } else {
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().setBody(payload);
        }
    }
}

