/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty4.codec.ObjectEncoder;

@ChannelHandler.Sharable
public class DatagramPacketObjectEncoder
extends MessageToMessageEncoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private ObjectEncoder delegateObjectEncoder = new ObjectEncoder();

    @Override
    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof Serializable) {
            Serializable payload = (Serializable)msg.content();
            ByteBuf buf = ctx.alloc().buffer();
            this.delegateObjectEncoder.encode(ctx, payload, buf);
            DefaultAddressedEnvelope<ByteBuf, InetSocketAddress> addressedEnvelop = new DefaultAddressedEnvelope<ByteBuf, InetSocketAddress>(buf, msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        }
    }
}

