/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty4.NettyConverter;
import org.apache.camel.component.netty4.http.NettyChannelBufferStreamCache;
import org.apache.camel.component.netty4.http.NettyChannelBufferStreamCacheOnCompletion;
import org.apache.camel.component.netty4.http.NettyHttpBinding;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty4.http.NettyHttpHelper;
import org.apache.camel.component.netty4.http.NettyHttpMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyHttpBinding
implements NettyHttpBinding,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new NettyHttpHeaderFilterStrategy();

    public DefaultNettyHttpBinding() {
    }

    public DefaultNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public DefaultNettyHttpBinding copy() {
        try {
            return (DefaultNettyHttpBinding)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public Message toCamelMessage(FullHttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(request, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isDisableStreamCache()) {
            answer.setBody(request.content());
        } else {
            NettyChannelBufferStreamCache cache = new NettyChannelBufferStreamCache(request.content());
            exchange.addOnCompletion((Synchronization)new NettyChannelBufferStreamCacheOnCompletion(cache));
            answer.setBody(cache);
        }
        return answer;
    }

    @Override
    public void populateCamelHeaders(FullHttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        String http;
        LOG.trace("populateCamelHeaders: {}", (Object)request);
        headers.put("CamelHttpMethod", request.getMethod().name());
        String s = request.getUri();
        if (s.contains("?")) {
            s = ObjectHelper.before((String)s, (String)"?");
        }
        String string = http = configuration.isSsl() ? "https://" : "http://";
        if (!s.startsWith(http)) {
            s = configuration.getPort() != 80 ? http + configuration.getHost() + ":" + configuration.getPort() + s : http + configuration.getHost() + s;
        }
        headers.put("CamelHttpUrl", s);
        URI uri = new URI(request.getUri());
        headers.put("CamelHttpUri", uri.getPath());
        headers.put("CamelHttpQuery", uri.getQuery());
        headers.put("CamelHttpRawQuery", uri.getRawQuery());
        String path = uri.getRawPath();
        if (configuration.getPath() != null) {
            String match;
            String matchPath = path.toLowerCase(Locale.US);
            String string2 = match = configuration.getPath() != null ? configuration.getPath().toLowerCase(Locale.US) : null;
            if (match != null && matchPath.startsWith(match)) {
                path = path.substring(configuration.getPath().length());
            }
        }
        headers.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)request.getMethod().name());
            LOG.trace("HTTP-Uri {}", (Object)request.getUri());
        }
        for (String name : request.headers().names()) {
            String value;
            if (name.toLowerCase(Locale.US).equals("content-type")) {
                name = "Content-Type";
            }
            if (name.toLowerCase(Locale.US).equals("authorization") && (value = request.headers().get(name)) != null && value.trim().startsWith("Basic")) {
                NettyHttpHelper.appendHeader(headers, "CamelHttpAuthentication", "Basic");
            }
            List<String> values = request.headers().getAll(name);
            Iterator it = ObjectHelper.createIterator(values);
            while (it.hasNext()) {
                Object extracted = it.next();
                String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, decoded);
            }
        }
        if (request.getUri().contains("?")) {
            String query = ObjectHelper.after((String)request.getUri(), (String)"?");
            Map uriParameters = URISupport.parseQuery((String)query, (boolean)false, (boolean)true);
            for (Map.Entry entry : uriParameters.entrySet()) {
                String name = (String)entry.getKey();
                Object values = entry.getValue();
                Iterator it = ObjectHelper.createIterator(values);
                while (it.hasNext()) {
                    Object extracted = it.next();
                    String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                    LOG.trace("URI-Parameter: {}", extracted);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                    NettyHttpHelper.appendHeader(headers, name, decoded);
                }
            }
        }
        if (request.getMethod().name().equals("POST") && request.headers().get("Content-Type") != null && request.headers().get("Content-Type").startsWith("application/x-www-form-urlencoded") && !configuration.isBridgeEndpoint()) {
            String charset = "UTF-8";
            String body = request.content().toString(Charset.forName(charset));
            if (ObjectHelper.isNotEmpty((Object)body)) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = this.shouldUrlDecodeHeader(configuration, "", pair[0], charset);
                        String value = this.shouldUrlDecodeHeader(configuration, name, pair[1], charset);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                        NettyHttpHelper.appendHeader(headers, name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    protected String shouldUrlDecodeHeader(NettyHttpConfiguration configuration, String headerName, Object value, String charset) throws UnsupportedEncodingException {
        if ("Content-Type".equals(headerName)) {
            return value.toString();
        }
        if (configuration.isUrlDecodeHeaders()) {
            return URLDecoder.decode(value.toString(), charset);
        }
        return value.toString();
    }

    @Override
    public Message toCamelMessage(FullHttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(null, response);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(response, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(response.content());
        return answer;
    }

    @Override
    public void populateCamelHeaders(FullHttpResponse response, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("populateCamelHeaders: {}", (Object)response);
        headers.put("CamelHttpResponseCode", response.getStatus().code());
        headers.put("CamelHttpResponseText", response.getStatus().reasonPhrase());
        for (String name : response.headers().names()) {
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            List<String> values = response.headers().getAll(name);
            Iterator it = ObjectHelper.createIterator(values);
            while (it.hasNext()) {
                Object extracted = it.next();
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, extracted);
            }
        }
    }

    @Override
    public HttpResponse toNettyResponse(Message message, NettyHttpConfiguration configuration) throws Exception {
        String connection;
        ByteBuf buffer;
        LOG.trace("toNettyResponse: {}", (Object)message);
        if (message.getBody() instanceof HttpResponse) {
            return (HttpResponse)message.getBody();
        }
        Object body = message.getBody();
        Exception cause = message.getExchange().getException();
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        LOG.trace("HTTP Status Code: {}", (Object)code);
        if (cause != null) {
            if (configuration.isTransferException()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(cause);
                oos.flush();
                IOHelper.close((Closeable[])new Closeable[]{oos, bos});
                body = NettyConverter.toByteBuffer(bos.toByteArray());
                message.setHeader("Content-Type", (Object)"application/x-java-serialized-object");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                body = NettyConverter.toByteBuffer(sw.toString().getBytes());
                message.setHeader("Content-Type", (Object)"text/plain");
            }
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        }
        if (body instanceof ByteBuf) {
            buffer = (ByteBuf)body;
        } else {
            buffer = (ByteBuf)message.getBody(ByteBuf.class);
            if (buffer == null) {
                byte[] data = (byte[])message.getBody(byte[].class);
                if (data != null) {
                    buffer = NettyConverter.toByteBuffer(data);
                } else {
                    String str = body != null ? (String)message.getMandatoryBody(String.class) : "";
                    buffer = NettyConverter.toByteBuffer(str.getBytes());
                }
            }
        }
        DefaultFullHttpResponse response = null;
        if (buffer != null) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(code), buffer);
            if (buffer.readerIndex() == buffer.writerIndex()) {
                buffer.setIndex(0, buffer.writerIndex());
            }
            int len = buffer.readableBytes();
            response.headers().set("Content-Length", (Object)len);
            LOG.trace("Content-Length: {}", (Object)len);
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(code));
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                response.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response.headers().set("Content-Type", (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        if ((connection = (String)message.getHeader("Connection", String.class)) == null) {
            connection = (String)message.getExchange().getProperty("Connection", String.class);
        }
        if (connection == null) {
            connection = configuration.isKeepAlive() ? "keep-alive" : "close";
        }
        response.headers().set("Connection", (Object)connection);
        if (connection.equalsIgnoreCase("close")) {
            message.setHeader("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        LOG.trace("Connection: {}", (Object)connection);
        return response;
    }

    @Override
    public HttpRequest toNettyRequest(Message message, String uri, NettyHttpConfiguration configuration) throws Exception {
        int indexOfPath;
        LOG.trace("toNettyRequest: {}", (Object)message);
        if (message.getBody() instanceof HttpRequest) {
            return (HttpRequest)message.getBody();
        }
        String uriForRequest = uri;
        if (configuration.isUseRelativePath() && (indexOfPath = uri.indexOf(new URI(uri).getPath())) > 0) {
            uriForRequest = uri.substring(indexOfPath);
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uriForRequest);
        Object body = message.getBody();
        if (body != null) {
            ByteBuf buffer;
            if (body instanceof ByteBuf) {
                buffer = (ByteBuf)body;
            } else {
                buffer = (ByteBuf)message.getBody(ByteBuf.class);
                if (buffer == null) {
                    byte[] data = (byte[])message.getMandatoryBody(byte[].class);
                    buffer = NettyConverter.toByteBuffer(data);
                }
            }
            if (buffer != null) {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uriForRequest, buffer);
                int len = buffer.readableBytes();
                request.headers().set("Content-Length", (Object)len);
                LOG.trace("Content-Length: {}", (Object)len);
            } else {
                throw new NoTypeConversionAvailableException(body, ByteBuf.class);
            }
        }
        HttpMethod method = NettyHttpHelper.createMethod(message, body != null);
        request.setMethod(method);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        Map skipRequestHeaders = null;
        if (configuration.isBridgeEndpoint()) {
            String queryString = (String)message.getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
            message.getHeaders().remove("host");
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key)) continue;
            Iterator it = ObjectHelper.createIterator(value, null, (boolean)true);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                request.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            request.headers().set("Content-Type", (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        URI u = new URI(uri);
        String hostHeader = u.getHost() + (u.getPort() == 80 ? "" : ":" + u.getPort());
        request.headers().set("Host", (Object)hostHeader);
        LOG.trace("Host: {}", (Object)hostHeader);
        String connection = (String)message.getHeader("Connection", String.class);
        if (connection == null) {
            connection = configuration.isKeepAlive() ? "keep-alive" : "close";
        }
        request.headers().set("Connection", (Object)connection);
        LOG.trace("Connection: {}", (Object)connection);
        return request;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

