/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty4.NettyComponent;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty4.http.DefaultNettyHttpBinding;
import org.apache.camel.component.netty4.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty4.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty4.http.HttpServerInitializerFactory;
import org.apache.camel.component.netty4.http.NettyHttpBinding;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.NettyHttpEndpoint;
import org.apache.camel.component.netty4.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty4.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty4.http.NettySharedHttpServer;
import org.apache.camel.component.netty4.http.RestNettyHttpBinding;
import org.apache.camel.component.netty4.http.handlers.HttpServerMultiplexChannelHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpComponent
extends NettyComponent
implements HeaderFilterStrategyAware,
RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpComponent.class);
    private final Map<Integer, HttpServerConsumerChannelFactory> multiplexChannelHandlers = new HashMap<Integer, HttpServerConsumerChannelFactory>();
    private final Map<String, HttpServerBootstrapFactory> bootstrapFactories = new HashMap<String, HttpServerBootstrapFactory>();
    private NettyHttpBinding nettyHttpBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    private NettyHttpSecurityConfiguration securityConfiguration;

    public NettyHttpComponent() {
        super(NettyHttpEndpoint.class);
        this.setConfiguration(new NettyHttpConfiguration());
        this.setHeaderFilterStrategy((HeaderFilterStrategy)new NettyHttpHeaderFilterStrategy());
        this.setNettyHttpBinding(new RestNettyHttpBinding(this.getHeaderFilterStrategy()));
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean hasSlash;
        boolean hasProtocol;
        HashMap options;
        NettyConfiguration config = this.getConfiguration() != null ? this.getConfiguration().copy() : new NettyHttpConfiguration();
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null && IntrospectionSupport.getProperties((Object)bootstrapConfiguration, options = new HashMap(), null, (boolean)false)) {
            IntrospectionSupport.setProperties((TypeConverter)this.getCamelContext().getTypeConverter(), (Object)config, options);
        }
        NettyHttpSecurityConfiguration securityConfiguration = (NettyHttpSecurityConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "securityConfiguration", NettyHttpSecurityConfiguration.class);
        Map securityOptions = IntrospectionSupport.extractProperties(parameters, (String)"securityConfiguration.");
        NettyHttpBinding bindingFromUri = (NettyHttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "nettyHttpBinding", NettyHttpBinding.class);
        int sharedPort = -1;
        NettySharedHttpServer shared = (NettySharedHttpServer)this.resolveAndRemoveReferenceParameter(parameters, "nettySharedHttpServer", NettySharedHttpServer.class);
        if (shared != null) {
            LOG.debug("Using NettySharedHttpServer: {} with port: {}", (Object)shared, (Object)shared.getPort());
            sharedPort = shared.getPort();
        }
        boolean bl = hasProtocol = remaining.startsWith("http://") || remaining.startsWith("http:") || remaining.startsWith("https://") || remaining.startsWith("https:");
        if (!hasProtocol) {
            remaining = "http://" + remaining;
        }
        boolean bl2 = hasSlash = remaining.startsWith("http://") || remaining.startsWith("https://");
        if (!hasSlash) {
            remaining = remaining.startsWith("http:") ? "http://" + remaining.substring(5) : "https://" + remaining.substring(6);
        }
        LOG.debug("Netty http url: {}", (Object)remaining);
        if (sharedPort != -1) {
            config.setPort(sharedPort);
        } else if (config.getPort() == -1 || config.getPort() == 0) {
            if (remaining.startsWith("http:")) {
                config.setPort(80);
            } else if (remaining.startsWith("https:")) {
                config.setPort(443);
            }
        }
        if (config.getPort() == -1) {
            throw new IllegalArgumentException("Port number must be configured");
        }
        config = this.parseConfiguration(config, remaining, parameters);
        this.setProperties(config, parameters);
        config.validateConfiguration();
        URI u = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        String addressUri = URISupport.createRemainingURI((URI)u, parameters).toString();
        NettyHttpEndpoint answer = new NettyHttpEndpoint(addressUri, this, config);
        if (answer.getNettyHttpBinding() == null) {
            NettyHttpBinding binding = null;
            binding = bindingFromUri != null ? bindingFromUri : this.getNettyHttpBinding();
            if (binding instanceof RestNettyHttpBinding) {
                RestNettyHttpBinding copy = ((RestNettyHttpBinding)binding).copy();
                answer.setNettyHttpBinding(copy);
            } else if (binding instanceof DefaultNettyHttpBinding) {
                DefaultNettyHttpBinding copy = ((DefaultNettyHttpBinding)binding).copy();
                answer.setNettyHttpBinding(copy);
            }
        }
        if (headerFilterStrategy != null) {
            answer.setHeaderFilterStrategy(headerFilterStrategy);
        } else if (answer.getHeaderFilterStrategy() == null) {
            answer.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (securityConfiguration != null) {
            answer.setSecurityConfiguration(securityConfiguration);
        } else if (answer.getSecurityConfiguration() == null) {
            answer.setSecurityConfiguration(this.getSecurityConfiguration());
        }
        if (securityOptions != null && !securityOptions.isEmpty()) {
            securityConfiguration = answer.getSecurityConfiguration();
            if (securityConfiguration == null) {
                securityConfiguration = new NettyHttpSecurityConfiguration();
                answer.setSecurityConfiguration(securityConfiguration);
            }
            this.setProperties(securityConfiguration, securityOptions);
            this.validateParameters(uri, securityOptions, null);
        }
        answer.setNettySharedHttpServer(shared);
        return answer;
    }

    @Override
    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        String safe = UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining);
        URI uri = new URI(safe);
        configuration.parseURI(uri, parameters, this, "http", "https");
        configuration.setProtocol("tcp");
        configuration.setTextline(false);
        if (configuration instanceof NettyHttpConfiguration) {
            ((NettyHttpConfiguration)configuration).setPath(uri.getPath());
        }
        return configuration;
    }

    public NettyHttpBinding getNettyHttpBinding() {
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public synchronized HttpServerConsumerChannelFactory getMultiplexChannelHandler(int port) {
        HttpServerConsumerChannelFactory answer = this.multiplexChannelHandlers.get(port);
        if (answer == null) {
            answer = new HttpServerMultiplexChannelHandler();
            answer.init(port);
            this.multiplexChannelHandlers.put(port, answer);
        }
        return answer;
    }

    protected synchronized HttpServerBootstrapFactory getOrCreateHttpNettyServerBootstrapFactory(NettyHttpConsumer consumer) {
        String key = consumer.getConfiguration().getAddress();
        HttpServerBootstrapFactory answer = this.bootstrapFactories.get(key);
        if (answer == null) {
            HttpServerConsumerChannelFactory channelFactory = this.getMultiplexChannelHandler(consumer.getConfiguration().getPort());
            answer = new HttpServerBootstrapFactory(channelFactory);
            answer.init(this.getCamelContext(), (NettyServerBootstrapConfiguration)consumer.getConfiguration(), (ChannelInitializer<Channel>)new HttpServerInitializerFactory(consumer));
            this.bootstrapFactories.put(key, answer);
        }
        return answer;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("netty4-http", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("netty4-http")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        boolean cors = config.isEnableCORS();
        String query = URISupport.createQueryString(map);
        String url = api ? "netty4-http:%s://%s:%s/%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : "netty4-http:%s://%s:%s/%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        url = String.format(url, scheme, host, port, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        NettyHttpEndpoint endpoint = (NettyHttpEndpoint)camelContext.getEndpoint(url, NettyHttpEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("netty4-http", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopServices(this.bootstrapFactories.values());
        this.bootstrapFactories.clear();
        ServiceHelper.stopService(this.multiplexChannelHandlers.values());
        this.multiplexChannelHandlers.clear();
    }
}

