/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.HttpContent;
import java.io.UnsupportedEncodingException;
import org.apache.camel.CamelException;
import org.apache.camel.component.netty4.NettyConverter;
import org.apache.camel.util.ObjectHelper;

public class NettyHttpOperationFailedException
extends CamelException {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String redirectLocation;
    private final int statusCode;
    private final String statusText;
    private final transient HttpContent content;
    private final String contentAsString;

    public NettyHttpOperationFailedException(String uri, int statusCode, String statusText, String location, HttpContent content) {
        super("Netty HTTP operation failed invoking " + uri + " with statusCode: " + statusCode + (location != null ? ", redirectLocation: " + location : ""));
        this.uri = uri;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.redirectLocation = location;
        this.content = content;
        String str = "";
        try {
            str = NettyConverter.toString(content.content(), null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.contentAsString = str;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRedirectError() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasRedirectLocation() {
        return ObjectHelper.isNotEmpty((Object)this.redirectLocation);
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Deprecated
    public HttpContent getHttpContent() {
        return this.content;
    }

    public String getContentAsString() {
        return this.contentAsString;
    }
}

