/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.component.netty4.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.handlers.HttpRestConsumerPath;
import org.apache.camel.component.netty4.http.handlers.HttpServerChannelHandler;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerMultiplexChannelHandler
extends SimpleChannelInboundHandler<Object>
implements HttpServerConsumerChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private static final AttributeKey<HttpServerChannelHandler> SERVER_HANDLER_KEY = AttributeKey.valueOf("serverHandler");
    private final Set<HttpServerChannelHandler> consumers = new CopyOnWriteArraySet<HttpServerChannelHandler>();
    private int port;
    private String token;
    private int len;

    @Override
    public void init(int port) {
        this.port = port;
        this.token = ":" + port;
        this.len = this.token.length();
    }

    @Override
    public void addConsumer(NettyHttpConsumer consumer) {
        this.consumers.add(new HttpServerChannelHandler(consumer));
    }

    @Override
    public void removeConsumer(NettyHttpConsumer consumer) {
        for (HttpServerChannelHandler handler : this.consumers) {
            if (handler.getConsumer() != consumer) continue;
            this.consumers.remove(handler);
        }
    }

    @Override
    public int consumers() {
        return this.consumers.size();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest request = (HttpRequest)msg;
        LOG.debug("Message received: {}", (Object)request);
        HttpServerChannelHandler handler = this.getHandler(request);
        if (handler != null) {
            Attribute<HttpServerChannelHandler> attr = ctx.channel().attr(SERVER_HANDLER_KEY);
            attr.set(handler);
            if (msg instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)msg;
                httpContent.content().retain();
            }
            handler.channelRead(ctx, request);
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush(response);
            ctx.close();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Attribute<HttpServerChannelHandler> attr = ctx.channel().attr(SERVER_HANDLER_KEY);
        HttpServerChannelHandler handler = attr.get();
        if (handler != null) {
            handler.exceptionCaught(ctx, cause);
        } else {
            if (cause instanceof ClosedChannelException) {
                LOG.debug("Channel already closed. Ignoring this exception.");
                return;
            }
            LOG.warn("HttpServerChannelHandler is not found as attachment to handle exception, send 404 back to the client.", cause);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush(response);
            ctx.close();
        }
    }

    private HttpServerChannelHandler getHandler(HttpRequest request) {
        HttpServerChannelHandler answer = null;
        String method = request.method().name();
        if (method == null) {
            return null;
        }
        String path = request.uri();
        int idx = path.indexOf(this.token);
        if (idx > -1) {
            path = path.substring(idx + this.len);
        }
        path = HttpServerMultiplexChannelHandler.pathAsKey(path);
        ArrayList<HttpRestConsumerPath> paths = new ArrayList<HttpRestConsumerPath>();
        for (HttpServerChannelHandler handler : this.consumers) {
            paths.add(new HttpRestConsumerPath(handler));
        }
        RestConsumerContextPathMatcher.ConsumerPath best = RestConsumerContextPathMatcher.matchBestPath((String)method, (String)path, paths);
        if (best != null) {
            answer = (HttpServerChannelHandler)best.getConsumer();
        }
        if (answer == null) {
            for (HttpServerChannelHandler handler : this.consumers) {
                boolean matchOnUriPrefix;
                NettyHttpConsumer consumer = handler.getConsumer();
                String consumerPath = consumer.getConfiguration().getPath();
                if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = consumer.getEndpoint().getConfiguration().isMatchOnUriPrefix()))) continue;
                answer = handler;
                break;
            }
        }
        return answer;
    }

    private static String pathAsKey(String path) {
        int idx;
        if (path == null || path.equals("/")) {
            path = "";
        }
        if ((idx = path.indexOf(63)) > -1) {
            path = path.substring(0, idx);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return UnsafeUriCharactersEncoder.encodeHttpURI((String)path);
    }
}

