/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.Exchange;
import org.slf4j.LoggerFactory;

public interface AggregationStrategy {
    public Exchange aggregate(Exchange var1, Exchange var2);

    default public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        return this.aggregate(oldExchange, newExchange);
    }

    default public boolean canPreComplete() {
        return false;
    }

    default public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
        return false;
    }

    default public void onCompletion(Exchange exchange) {
    }

    default public void timeout(Exchange exchange, int index, int total, long timeout2) {
    }

    default public void onOptimisticLockFailure(Exchange oldExchange, Exchange newExchange) {
        LoggerFactory.getLogger(this.getClass()).trace("onOptimisticLockFailure with AggregationStrategy: {}, oldExchange: {}, newExchange: {}", new Object[]{this, oldExchange, newExchange});
    }
}

