/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.LoggingLevel;
import org.apache.camel.StartupListener;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanIntrospection
extends ServiceSupport
implements BeanIntrospection,
CamelContextAware,
StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanIntrospection.class);
    private static final Pattern SECRETS = Pattern.compile(".*(passphrase|password|secretKey).*", 2);
    private CamelContext camelContext;
    private volatile boolean preStartDone;
    private final List<String> preStartLogs = new ArrayList<String>();
    private final AtomicLong invoked = new AtomicLong();
    private volatile boolean extendedStatistics;
    private LoggingLevel loggingLevel = LoggingLevel.TRACE;
    private CamelLogger logger = new CamelLogger(LOG, this.loggingLevel);

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public long getInvokedCounter() {
        return this.invoked.get();
    }

    @Override
    public void resetCounters() {
        this.invoked.set(0L);
    }

    @Override
    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    @Override
    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Override
    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
        this.logger = new CamelLogger(LOG, loggingLevel);
    }

    private void log(String method, Object target, Object ... args2) {
        Object obj = "null";
        if (args2 != null && args2.length > 0) {
            obj = Arrays.asList(args2);
        }
        if (target != null) {
            target = target.getClass().getName() + "@" + Integer.toHexString(target.hashCode());
        }
        String line = target == null ? "Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + "]" : (args2 == null ? "Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + ", Target: " + target + "]" : "Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + ", Target: " + target + ", Arguments: " + obj + "]");
        if (this.preStartDone) {
            this.logger.log(line);
        } else {
            this.preStartLogs.add(line);
        }
    }

    @Override
    public BeanIntrospection.ClassInfo cacheClass(Class<?> clazz) {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("cacheClass", clazz, new Object[0]);
        }
        return IntrospectionSupport.cacheClass(clazz);
    }

    @Override
    public void clearCache() {
        if (this.invoked.get() > 0L) {
            this.invoked.incrementAndGet();
            if (!this.preStartDone || this.logger.shouldLog()) {
                this.log("clearCache", null, new Object[0]);
            }
            IntrospectionSupport.clearCache();
        }
    }

    @Override
    public long getCachedClassesCounter() {
        if (this.invoked.get() > 0L) {
            return IntrospectionSupport.getCacheCounter();
        }
        return 0L;
    }

    @Override
    public boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix) {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("getProperties", target, new Object[0]);
        }
        return IntrospectionSupport.getProperties(target, properties, optionPrefix);
    }

    @Override
    public boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean includeNull) {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("getProperties", target, new Object[0]);
        }
        return IntrospectionSupport.getProperties(target, properties, optionPrefix, includeNull);
    }

    @Override
    public Object getOrElseProperty(Object target, String propertyName, Object defaultValue, boolean ignoreCase) {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("getOrElseProperty", target, propertyName);
        }
        return IntrospectionSupport.getOrElseProperty(target, propertyName, defaultValue, ignoreCase);
    }

    @Override
    public Method getPropertyGetter(Class<?> type, String propertyName, boolean ignoreCase) throws NoSuchMethodException {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("getPropertyGetter", type, propertyName);
        }
        return IntrospectionSupport.getPropertyGetter(type, propertyName, ignoreCase);
    }

    @Override
    public boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) throws Exception {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            Object text = value;
            if (SECRETS.matcher(name).find()) {
                text = "xxxxxx";
            }
            this.log("setProperty", target, name, text);
        }
        return IntrospectionSupport.setProperty(context, typeConverter, target, name, value, refName, allowBuilderPattern, allowPrivateSetter, ignoreCase);
    }

    @Override
    public boolean setProperty(CamelContext context, Object target, String name, Object value) throws Exception {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            Object text = value;
            if (SECRETS.matcher(name).find()) {
                text = "xxxxxx";
            }
            this.log("setProperty", target, name, text);
        }
        return IntrospectionSupport.setProperty(context, target, name, value);
    }

    @Override
    public Set<Method> findSetterMethods(Class<?> clazz, String name, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) {
        this.invoked.incrementAndGet();
        if (!this.preStartDone || this.logger.shouldLog()) {
            this.log("findSetterMethods", clazz, new Object[0]);
        }
        return IntrospectionSupport.findSetterMethods(clazz, name, allowBuilderPattern, allowPrivateSetter, ignoreCase);
    }

    @Override
    public void afterPropertiesConfigured(CamelContext camelContext) {
        this.preStartLogs.forEach(this.logger::log);
        this.preStartLogs.clear();
        this.preStartDone = true;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.camelContext != null) {
            this.camelContext.addStartupListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.invoked.get() > 0L) {
            IntrospectionSupport.stop();
        }
        if (this.extendedStatistics) {
            LOG.info("Stopping BeanIntrospection which was invoked: {} times", (Object)this.invoked.get());
        } else {
            LOG.debug("Stopping BeanIntrospection which was invoked: {} times", (Object)this.invoked.get());
        }
    }

    @Override
    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        this.afterPropertiesConfigured(this.camelContext);
    }
}

