/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SagaActionUriDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.model.SagaOptionDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;

@Metadata(label="eip,routing")
@XmlRootElement(name="saga")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SagaDefinition
extends OutputDefinition<SagaDefinition> {
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.model.SagaPropagation", defaultValue="REQUIRED", enums="REQUIRED,REQUIRES_NEW,MANDATORY,SUPPORTS,NOT_SUPPORTED,NEVER")
    private String propagation;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.model.SagaCompletionMode", defaultValue="AUTO", enums="AUTO,MANUAL")
    private String completionMode;
    @XmlAttribute
    @Metadata(javaType="java.lang.Long", deprecationNote="Use timeout instead")
    @Deprecated
    private String timeoutInMilliseconds;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration")
    private String timeout;
    @XmlElement
    private SagaActionUriDefinition compensation;
    @XmlElement
    private SagaActionUriDefinition completion;
    @XmlElement(name="option")
    private List<SagaOptionDefinition> options;
    @XmlAttribute
    private String sagaServiceRef;
    @XmlTransient
    private CamelSagaService sagaService;

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "saga";
        }
        return "saga[" + desc + "]";
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "Saga -> [" + this.outputs + "]";
        }
        return "Saga[" + desc + "] -> [" + this.outputs + "]";
    }

    public SagaActionUriDefinition getCompensation() {
        return this.compensation;
    }

    public void setCompensation(SagaActionUriDefinition compensation) {
        this.compensation = compensation;
    }

    public SagaActionUriDefinition getCompletion() {
        return this.completion;
    }

    public void setCompletion(SagaActionUriDefinition completion) {
        this.completion = completion;
    }

    public String getPropagation() {
        return this.propagation;
    }

    public void setPropagation(String propagation) {
        this.propagation = propagation;
    }

    public String getCompletionMode() {
        return this.completionMode;
    }

    public void setCompletionMode(String completionMode) {
        this.completionMode = completionMode;
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    public void setSagaService(CamelSagaService sagaService) {
        this.sagaService = sagaService;
    }

    public String getSagaServiceRef() {
        return this.sagaServiceRef;
    }

    public void setSagaServiceRef(String sagaServiceRef) {
        this.sagaServiceRef = sagaServiceRef;
    }

    public List<SagaOptionDefinition> getOptions() {
        return this.options;
    }

    public void setOptions(List<SagaOptionDefinition> options) {
        this.options = options;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    public String getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeoutInMilliseconds(String timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    private void addOption(String option, Expression expression) {
        if (this.options == null) {
            this.options = new ArrayList<SagaOptionDefinition>();
        }
        this.options.add(new SagaOptionDefinition(option, expression));
    }

    public SagaDefinition compensation(String compensation) {
        if (this.compensation != null) {
            throw new IllegalStateException("Compensation has already been set");
        }
        this.compensation = new SagaActionUriDefinition(compensation);
        return this;
    }

    public SagaDefinition completion(String completion) {
        if (this.completion != null) {
            throw new IllegalStateException("Completion has already been set");
        }
        this.completion = new SagaActionUriDefinition(completion);
        return this;
    }

    public SagaDefinition propagation(SagaPropagation propagation) {
        this.setPropagation(propagation.name());
        return this;
    }

    public SagaDefinition sagaService(CamelSagaService sagaService) {
        this.setSagaService(sagaService);
        return this;
    }

    public SagaDefinition sagaServiceRef(String sagaServiceRef) {
        this.setSagaServiceRef(sagaServiceRef);
        return this;
    }

    public SagaDefinition completionMode(SagaCompletionMode completionMode) {
        return this.completionMode(completionMode.name());
    }

    public SagaDefinition completionMode(String completionMode) {
        this.setCompletionMode(completionMode);
        return this;
    }

    public SagaDefinition option(String option, Expression expression) {
        this.addOption(option, expression);
        return this;
    }

    public SagaDefinition timeout(Duration duration) {
        return this.timeout(TimeUtils.printDuration(duration));
    }

    public SagaDefinition timeout(long timeout2, TimeUnit unit) {
        return this.timeout(Duration.ofMillis(unit.toMillis(timeout2)));
    }

    public SagaDefinition timeout(String duration) {
        this.setTimeout(duration);
        return this;
    }

    protected String description() {
        StringBuilder desc = new StringBuilder();
        this.addField(desc, "compensation", this.compensation);
        this.addField(desc, "completion", this.completion);
        this.addField(desc, "propagation", this.propagation);
        return desc.toString();
    }

    private void addField(StringBuilder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (builder.length() > 0) {
            builder.append(',');
        }
        builder.append(key).append(':').append(value);
    }
}

