/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.RecipientListProcessor;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.errorhandler.NoErrorHandler;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientList
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
ErrorHandlerAware {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientList.class);
    private final CamelContext camelContext;
    private String id;
    private String routeId;
    private Processor errorHandler;
    private ProducerCache producerCache;
    private final Expression expression;
    private final String delimiter;
    private boolean parallelProcessing;
    private boolean parallelAggregate;
    private boolean stopOnAggregateException;
    private boolean stopOnException;
    private boolean ignoreInvalidEndpoints;
    private boolean streaming;
    private long timeout;
    private int cacheSize;
    private Processor onPrepare;
    private boolean shareUnitOfWork;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;
    private volatile ExecutorService aggregateExecutorService;
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();
    private RecipientListProcessor recipientListProcessor;

    public RecipientList(CamelContext camelContext) {
        this(camelContext, ",");
    }

    public RecipientList(CamelContext camelContext, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        StringHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.delimiter = delimiter;
        this.expression = null;
    }

    public RecipientList(CamelContext camelContext, Expression expression) {
        this(camelContext, expression, ",");
    }

    public RecipientList(CamelContext camelContext, Expression expression, String delimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        StringHelper.notEmpty(delimiter, "delimiter");
        this.camelContext = camelContext;
        this.expression = expression;
        this.delimiter = delimiter;
    }

    public Processor newPipeline(CamelContext camelContext, Collection<Processor> processors) {
        return new RecipientListPipeline(this, camelContext, processors);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("RecipientList has not been started: " + this);
        }
        return this.recipientListProcessor.process(exchange, callback);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.errorHandler == null) {
            this.errorHandler = new NoErrorHandler(null);
        }
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                LOG.debug("RecipientList {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache(this, this.camelContext, this.cacheSize);
                LOG.debug("RecipientList {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        if (this.timeout > 0L) {
            this.aggregateExecutorService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "RecipientList-AggregateTask", 0);
        }
        this.recipientListProcessor = new RecipientListProcessor(this.camelContext, null, this.expression, this.delimiter, this.producerCache, this.getAggregationStrategy(), this.isParallelProcessing(), this.getExecutorService(), this.isShutdownExecutorService(), this.isStreaming(), this.isStopOnException(), this.getTimeout(), this.getOnPrepare(), this.isShareUnitOfWork(), this.isParallelAggregate(), this.isStopOnAggregateException());
        this.recipientListProcessor.setErrorHandler(this.errorHandler);
        this.recipientListProcessor.setAggregateExecutorService(this.aggregateExecutorService);
        this.recipientListProcessor.setIgnoreInvalidEndpoints(this.isIgnoreInvalidEndpoints());
        this.recipientListProcessor.setCacheSize(this.getCacheSize());
        this.recipientListProcessor.setId(this.getId());
        this.recipientListProcessor.setRouteId(this.getRouteId());
        ServiceHelper.startService(this.aggregationStrategy, this.producerCache, this.recipientListProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache, this.aggregationStrategy, this.recipientListProcessor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache, this.aggregationStrategy, this.recipientListProcessor);
        if (this.aggregateExecutorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.aggregateExecutorService);
        }
        if (this.shutdownExecutorService && this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(boolean parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public boolean isStopOnAggregateException() {
        return this.stopOnAggregateException;
    }

    public void setStopOnAggregateException(boolean stopOnAggregateException) {
        this.stopOnAggregateException = stopOnAggregateException;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout2) {
        this.timeout = timeout2;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    private static final class RecipientListPipeline
    extends Pipeline {
        private final RecipientList recipientList;

        public RecipientListPipeline(RecipientList recipientList, CamelContext camelContext, Collection<Processor> processors) {
            super(camelContext, processors);
            this.recipientList = recipientList;
        }

        @Override
        public void setId(String id) {
            this.recipientList.setId(id);
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String toString() {
            return null;
        }
    }
}

