/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.Timer;
import org.apache.camel.processor.resequencer.Element;
import org.apache.camel.processor.resequencer.ElementComparator;
import org.apache.camel.processor.resequencer.MessageRejectedException;
import org.apache.camel.processor.resequencer.Sequence;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.processor.resequencer.Timeout;
import org.apache.camel.util.concurrent.ThreadHelper;

public class ResequencerEngine<E> {
    private Element<E> lastDelivered;
    private long timeout;
    private Sequence<Element<E>> sequence;
    private Timer timer;
    private SequenceSender<E> sequenceSender;
    private Boolean rejectOld;

    public ResequencerEngine(SequenceElementComparator<E> comparator) {
        this.sequence = ResequencerEngine.createSequence(comparator);
        this.timeout = 2000L;
        this.lastDelivered = null;
    }

    public void start() {
        this.timer = new Timer(ThreadHelper.resolveThreadName("Camel Thread ${counter} - ${name}", "Stream Resequencer Timer"), true);
    }

    public void stop() {
        this.timer.cancel();
    }

    public synchronized int size() {
        return this.sequence.size();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout2) {
        this.timeout = timeout2;
    }

    public Boolean getRejectOld() {
        return this.rejectOld;
    }

    public void setRejectOld(Boolean rejectOld) {
        this.rejectOld = rejectOld;
    }

    public SequenceSender<E> getSequenceSender() {
        return this.sequenceSender;
    }

    public void setSequenceSender(SequenceSender<E> sequenceSender) {
        this.sequenceSender = sequenceSender;
    }

    E getLastDelivered() {
        if (this.lastDelivered == null) {
            return null;
        }
        return this.lastDelivered.getObject();
    }

    void setLastDelivered(E o) {
        this.lastDelivered = new Element<E>(o);
    }

    public synchronized void insert(E o) {
        Element<E> element = new Element<E>(o);
        if (!this.sequence.comparator().isValid(element)) {
            throw new IllegalArgumentException("Element cannot be used in comparator: " + this.sequence.comparator());
        }
        if (this.rejectOld != null && this.rejectOld.booleanValue() && this.beforeLastDelivered(element)) {
            throw new MessageRejectedException("rejecting message [" + element.getObject() + "], it should have been sent before the last delivered message [" + this.lastDelivered.getObject() + "]");
        }
        this.sequence.add(element);
        Element<E> successor = this.sequence.successor(element);
        if (successor != null) {
            successor.cancel();
        }
        if (!this.successorOfLastDelivered(element) && this.sequence.predecessor(element) == null) {
            element.schedule(this.defineTimeout());
        }
    }

    public synchronized void deliver() throws Exception {
        while (this.deliverNext()) {
        }
    }

    public boolean deliverNext() throws Exception {
        if (this.sequence.isEmpty()) {
            return false;
        }
        Element element = (Element)this.sequence.first();
        if (element.scheduled()) {
            return false;
        }
        this.sequence.remove(element);
        this.lastDelivered = element;
        this.sequenceSender.sendElement(element.getObject());
        return true;
    }

    private boolean successorOfLastDelivered(Element<E> element) {
        if (this.lastDelivered == null) {
            return false;
        }
        return this.sequence.comparator().successor(element, this.lastDelivered);
    }

    private boolean beforeLastDelivered(Element<E> element) {
        if (this.lastDelivered == null) {
            return false;
        }
        return this.sequence.comparator().compare(element, this.lastDelivered) < 0;
    }

    private Timeout defineTimeout() {
        return new Timeout(this.timer, this.timeout);
    }

    private static <E> Sequence<Element<E>> createSequence(SequenceElementComparator<E> comparator) {
        return new Sequence<Element<E>>(new ElementComparator<E>(comparator));
    }
}

