/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public abstract class AbstractReifier
implements BeanRepository {
    protected final Route route;
    protected final CamelContext camelContext;

    public AbstractReifier(Route route) {
        this.route = ObjectHelper.notNull(route, "Route");
        this.camelContext = route.getCamelContext();
    }

    public AbstractReifier(CamelContext camelContext) {
        this.route = null;
        this.camelContext = ObjectHelper.notNull(camelContext, "CamelContext");
    }

    protected String parseString(String text) {
        return CamelContextHelper.parseText(this.camelContext, text);
    }

    protected Boolean parseBoolean(String text) {
        return CamelContextHelper.parseBoolean(this.camelContext, text);
    }

    protected boolean parseBoolean(String text, boolean def) {
        Boolean b = this.parseBoolean(text);
        return b != null ? b : def;
    }

    protected Long parseLong(String text) {
        return CamelContextHelper.parseLong(this.camelContext, text);
    }

    protected long parseLong(String text, long def) {
        Long l = this.parseLong(text);
        return l != null ? l : def;
    }

    protected Long parseDuration(String text) {
        Duration d = CamelContextHelper.parseDuration(this.camelContext, text);
        return d != null ? Long.valueOf(d.toMillis()) : null;
    }

    protected long parseDuration(String text, long def) {
        Duration d = CamelContextHelper.parseDuration(this.camelContext, text);
        return d != null ? d.toMillis() : def;
    }

    protected Integer parseInt(String text) {
        return CamelContextHelper.parseInteger(this.camelContext, text);
    }

    protected int parseInt(String text, int def) {
        Integer i = this.parseInt(text);
        return i != null ? i : def;
    }

    protected Float parseFloat(String text) {
        return CamelContextHelper.parseFloat(this.camelContext, text);
    }

    protected float parseFloat(String text, float def) {
        Float f = this.parseFloat(text);
        return f != null ? f.floatValue() : def;
    }

    protected <T> T parse(Class<T> clazz, String text) {
        return CamelContextHelper.parse(this.camelContext, clazz, text);
    }

    protected <T> T parse(Class<T> clazz, Object text) {
        if (text instanceof String) {
            text = this.parseString((String)text);
        }
        return CamelContextHelper.convertTo(this.camelContext, clazz, text);
    }

    protected Expression createExpression(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Expression createExpression(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Predicate createPredicate(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Predicate createPredicate(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Object or(Object a, Object b) {
        return a != null ? a : b;
    }

    protected Object asRef(String s) {
        return s != null ? (s.startsWith("#") ? s : "#" + s) : null;
    }

    protected BeanRepository getRegistry() {
        return this.camelContext.getRegistry();
    }

    public <T> T mandatoryLookup(String name, Class<T> beanType) {
        return CamelContextHelper.mandatoryLookup(this.camelContext, name, beanType);
    }

    public <T> T findSingleByType(Class<T> type) {
        return CamelContextHelper.findByType(this.camelContext, type);
    }

    @Override
    public Object lookupByName(String name) {
        if (name != null && name.startsWith("#class:")) {
            return this.createBean(name, Object.class);
        }
        if (name != null && name.startsWith("#type:")) {
            return this.lookupBean(name, Object.class);
        }
        return this.getRegistry().lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        if (name != null && name.startsWith("#class:")) {
            return this.createBean(name, type);
        }
        if (name != null && name.startsWith("#type:")) {
            return this.lookupBean(name, type);
        }
        return this.lookupByNameAndType(name, type);
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        if (name != null && name.startsWith("#class:")) {
            return this.createBean(name, type);
        }
        if (name != null && name.startsWith("#type:")) {
            return this.lookupBean(name, type);
        }
        return this.getRegistry().lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return this.getRegistry().findByTypeWithName(type);
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        return this.getRegistry().findByType(type);
    }

    @Override
    public Object unwrap(Object value) {
        return this.getRegistry().unwrap(value);
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        return CamelContextHelper.getMandatoryEndpoint(this.camelContext, uri);
    }

    private <T> T createBean(String name, Class<T> type) {
        try {
            return this.doCreateBean(name, type);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }

    private <T> T doCreateBean(String name, Class<T> type) throws Exception {
        String factoryMethod = null;
        String parameters = null;
        String className = name.substring(7);
        if (className.endsWith(")") && className.indexOf(40) != -1) {
            parameters = StringHelper.after(className, "(");
            parameters = parameters.substring(0, parameters.length() - 1);
            className = StringHelper.before(className, "(");
        }
        if (className != null && className.indexOf(35) != -1) {
            factoryMethod = StringHelper.after(className, "#");
            className = StringHelper.before(className, "#");
        }
        Class<?> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(className);
        Object answer = factoryMethod != null && parameters != null ? PropertyBindingSupport.newInstanceFactoryParameters(this.camelContext, clazz, factoryMethod, parameters) : (factoryMethod != null ? this.camelContext.getInjector().newInstance(type, factoryMethod) : (parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(this.camelContext, clazz, parameters) : this.camelContext.getInjector().newInstance(clazz)));
        if (answer == null) {
            throw new IllegalStateException("Cannot create bean: " + name);
        }
        return type.cast(answer);
    }

    private <T> T lookupBean(String name, Class<T> type) {
        try {
            return this.doLookupBean(name, type);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }

    private <T> T doLookupBean(String name, Class<T> type) throws ClassNotFoundException {
        Class<?> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name.substring(6));
        Set<?> found = this.getRegistry().findByType(clazz);
        if (found == null || found.isEmpty()) {
            throw new NoSuchBeanException(null, clazz.getName());
        }
        if (found.size() > 1) {
            throw new NoSuchBeanException("Found " + found.size() + " beans of type: " + clazz + ". Only one bean expected.");
        }
        Object answer = found.iterator().next();
        return type.cast(answer);
    }
}

